/*
 * Decompiled with CFR 0.152.
 */
package de.intevation.printlayout.tools;

import de.intevation.printlayout.DocumentManager;
import de.intevation.printlayout.MatrixTools;
import de.intevation.printlayout.tools.BoxInteractor;
import de.intevation.printlayout.tools.DrawingAttributes;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.svggen.SVGBasicStroke;
import org.apache.batik.svggen.SVGColor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.apache.batik.svggen.SVGStrokeDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class BoxFactory
implements BoxInteractor.Factory {
    protected DrawingAttributes attributes;

    protected String getSVGColor(Color c, String attrName, SVGDocument document) {
        SVGPaintDescriptor desc = SVGColor.toSVG((Color)c, (SVGGeneratorContext)SVGGeneratorContext.createDefault((Document)document));
        Map attrMap = desc.getAttributeMap(null);
        return (String)attrMap.get(attrName);
    }

    public void setDrawingAttributes(DrawingAttributes attributes) {
        this.attributes = attributes;
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.attributes;
    }

    public DocumentManager.DocumentModifier createBox(final Rectangle2D rect, final AffineTransform xform) {
        return new DocumentManager.DocumentModifier(){

            public Object run(DocumentManager documentManager) {
                SVGDocument document = documentManager.getSVGDocument();
                Paint strokeColor = BoxFactory.this.attributes.getStrokeColor();
                Stroke stroke = BoxFactory.this.attributes.getStroke();
                Paint fillColor = BoxFactory.this.attributes.getFillColor();
                String svgNS = "http://www.w3.org/2000/svg";
                AbstractElement box = (AbstractElement)document.createElementNS(svgNS, "rect");
                AbstractElement group = (AbstractElement)document.createElementNS(svgNS, "g");
                group.setAttributeNS(null, "transform", MatrixTools.toSVGString(xform));
                BoxFactory.this.setRectAttributes(box, rect);
                if (strokeColor != null && strokeColor instanceof Color) {
                    box.setAttributeNS(null, "stroke", BoxFactory.this.getSVGColor((Color)strokeColor, "stroke", document));
                    box.setAttributeNS(null, "stroke-opacity", BoxFactory.this.getSVGColor((Color)strokeColor, "stroke-opacity", document));
                }
                if (fillColor != null && fillColor instanceof Color) {
                    box.setAttributeNS(null, "fill", BoxFactory.this.getSVGColor((Color)fillColor, "fill", document));
                    box.setAttributeNS(null, "fill-opacity", BoxFactory.this.getSVGColor((Color)fillColor, "fill-opacity", document));
                } else {
                    box.setAttributeNS(null, "fill", "none");
                }
                if (stroke != null && stroke instanceof BasicStroke) {
                    Map attributeMap = BoxFactory.this.getStrokeAttrMap((BasicStroke)stroke, document);
                    for (Map.Entry entry : attributeMap.entrySet()) {
                        box.setAttributeNS(null, (String)entry.getKey(), (String)entry.getValue());
                    }
                }
                box.setAttributeNS(null, "pointer-events", "all");
                group.setAttributeNS(null, "id", documentManager.uniqueObjectID());
                group.appendChild((Node)box);
                AbstractElement parent = (AbstractElement)document.getElementById("viewer-layout-sheet-svg");
                parent.appendChild((Node)group);
                return null;
            }
        };
    }

    protected Map getStrokeAttrMap(BasicStroke stroke, SVGDocument document) {
        SVGStrokeDescriptor ssd = new SVGBasicStroke(SVGGeneratorContext.createDefault((Document)document)).toSVG(stroke);
        return ssd.getAttributeMap(null);
    }

    protected void setRectAttributes(AbstractElement el, Rectangle2D rect) {
        el.setAttributeNS(null, "x", String.valueOf(rect.getX()));
        el.setAttributeNS(null, "y", String.valueOf(rect.getY()));
        el.setAttributeNS(null, "width", String.valueOf(rect.getWidth()));
        el.setAttributeNS(null, "height", String.valueOf(rect.getHeight()));
    }
}

