/*
 * Decompiled with CFR 0.152.
 */
package de.intevation.printlayout;

public class TypoUnits {
    public static final int TYPE_MM = 0;
    public static final int TYPE_IN = 1;
    public static final int TYPE_PT = 2;
    public static final int TYPE_PC = 3;
    public static final int TYPE_CM = 4;
    public static final int TYPE_PERC = 5;
    public static final int TYPE_PX = 6;
    public static final int TYPE_EM = 7;
    public static final int TYPE_EX = 8;

    public static final double mm2in(double in) {
        return in * 0.039370079;
    }

    public static final double in2mm(double in) {
        return in * 25.4;
    }

    public static final double pt2mm(double pt) {
        return pt * 0.3514598;
    }

    public static final double pc2mm(double pc) {
        return pc * 4.2175176;
    }

    public static final double cm2mm(double cm) {
        return cm * 10.0;
    }

    public static int stringToMM(String s, double px2mm, double max, double[] v) {
        if (s == null || s.length() == 0) {
            throw new NumberFormatException();
        }
        if ((s = s.trim().toLowerCase()).endsWith("mm")) {
            s = s.substring(0, s.length() - 2).trim();
            v[0] = Double.parseDouble(s);
            return 0;
        }
        if (s.endsWith("in")) {
            s = s.substring(0, s.length() - 2).trim();
            v[0] = TypoUnits.in2mm(Double.parseDouble(s));
            return 1;
        }
        if (s.endsWith("cm")) {
            s = s.substring(0, s.length() - 2).trim();
            v[0] = TypoUnits.cm2mm(Double.parseDouble(s));
            return 4;
        }
        if (s.endsWith("pt")) {
            s = s.substring(0, s.length() - 2).trim();
            v[0] = TypoUnits.pt2mm(Double.parseDouble(s));
            return 2;
        }
        if (s.endsWith("pc")) {
            s = s.substring(0, s.length() - 2).trim();
            v[0] = TypoUnits.pc2mm(Double.parseDouble(s));
            return 3;
        }
        if (s.endsWith("%")) {
            s = s.substring(0, s.length() - 1).trim();
            double p = Double.parseDouble(s);
            v[0] = p * 0.01 * max;
            return 5;
        }
        if (s.endsWith("em") || s.endsWith("ex")) {
            s = s.substring(0, s.length() - 2).trim();
        }
        v[0] = Double.parseDouble(s) * px2mm;
        return 6;
    }
}

