/*
 * Decompiled with CFR 0.152.
 */
package de.intevation.printlayout;

import de.intevation.printlayout.DocumentManager;
import de.intevation.printlayout.ExtraData;
import de.intevation.printlayout.MapData;
import de.intevation.printlayout.MatrixTools;
import java.io.Serializable;
import java.text.NumberFormat;
import org.apache.batik.dom.AbstractElement;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTextElement;

public class ScaleUpdater
implements Serializable,
ExtraData.ChangeListener {
    protected String scaleID;
    protected NumberFormat format = NumberFormat.getInstance();

    public ScaleUpdater() {
        this.format.setMaximumFractionDigits(3);
        this.format.setGroupingUsed(false);
    }

    public ScaleUpdater(String id) {
        this();
        this.scaleID = id;
    }

    public String getScaleID() {
        return this.scaleID;
    }

    public void setScaleId(String id) {
        this.scaleID = id;
    }

    public void elementTransformed(ExtraData.Event evt) {
        SVGLocatable loc = (SVGLocatable)evt.getElement();
        DocumentManager manager = (DocumentManager)evt.getSource();
        this.elementTransformed(loc, manager);
    }

    public void elementTransformed(SVGLocatable loc, DocumentManager manager) {
        SVGElement textGroup;
        String id = ((AbstractElement)loc).getAttributeNS(null, "id");
        if (id == null) {
            return;
        }
        Object data = manager.getData(id);
        if (!(data instanceof MapData)) {
            return;
        }
        MapData map = (MapData)data;
        SVGDocument document = manager.getSVGDocument();
        SVGElement sheet = (SVGElement)document.getElementById("viewer-layout-sheet-svg");
        if (sheet == null) {
            return;
        }
        SVGMatrix xform = loc.getTransformToElement(sheet);
        MatrixTools.Decomposition d = MatrixTools.decompose(xform);
        double scale = Math.abs(1000.0 / (map.getInitialScale() * Math.max(d.scx, d.scy)));
        if (scale > 10000.0) {
            scale = Math.round(scale);
        }
        if ((textGroup = (SVGElement)document.getElementById(this.scaleID)) == null) {
            return;
        }
        NodeList children = textGroup.getChildNodes();
        SVGTextElement text = null;
        for (int i = children.getLength() - 1; i >= 0; --i) {
            AbstractElement child = (AbstractElement)children.item(i);
            if (!(child instanceof SVGTextElement)) continue;
            text = (SVGTextElement)child;
            break;
        }
        if (text == null) {
            return;
        }
        text.setTextContent("1:" + this.format.format(scale));
    }
}

