/*
 * Decompiled with CFR 0.152.
 */
package de.intevation.printlayout;

import java.util.TreeMap;

public class PaperSizes {
    private static final TreeMap SIZES = new TreeMap();

    public static String getSheet(double width, double height) {
        StringBuffer sb = new StringBuffer(512);
        sb.append("<?xml version=\"1.0\" standalone=\"no\"?>\n").append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" ").append("\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">").append("<svg width=\"").append(width + 40.0).append("mm\" height=\"").append(height + 40.0).append("mm\"").append(" version=\"1.1\"").append(" viewBox=\"0 0 250 337\"").append(" xmlns=\"http://www.w3.org/2000/svg\">").append("\t<rect x=\"20\" y=\"20\"").append(" width=\"").append(width).append("\" height=\"").append(height).append("\"").append(" style=\"fill:white\"/>").append(" <svg width=\"").append(width).append("\" height=\"").append(height).append("\"").append(" x=\"20\" y=\"20\"").append(" id=\"viewer-layout-sheet-svg\"").append(" overflow=\"visible\">").append("</svg>").append("</svg>");
        return sb.toString();
    }

    public static void putPageSize(String id, double width, double height) {
        SIZES.put(id, new double[]{width, height});
    }

    public static boolean getPageSize(String id, double[] v) {
        double[] dim = (double[])SIZES.get(id);
        if (dim == null) {
            return false;
        }
        v[0] = dim[0];
        v[1] = dim[1];
        return true;
    }

    public static String sheetForPaperSize(String id) {
        return PaperSizes.sheetForPaperSize(id, false);
    }

    public static String sheetForPaperSize(String id, boolean landscape) {
        double[] dim = (double[])SIZES.get(id);
        if (dim == null) {
            return null;
        }
        return landscape ? PaperSizes.getSheet(dim[1], dim[0]) : PaperSizes.getSheet(dim[0], dim[1]);
    }

    static {
        SIZES.put("DIN A4", new double[]{210.0, 297.0});
        SIZES.put("DIN A0", new double[]{841.0, 1189.0});
        SIZES.put("DIN A1", new double[]{594.0, 841.0});
        SIZES.put("DIN A2", new double[]{420.0, 594.0});
        SIZES.put("DIN A3", new double[]{297.0, 420.0});
    }
}

