/*
 * Decompiled with CFR 0.152.
 */
package de.intevation.printlayout;

import java.awt.geom.AffineTransform;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.svg.SVGMatrix;

public class MatrixTools {
    private MatrixTools() {
    }

    public static Decomposition decompose(SVGMatrix matrix) {
        return new Decomposition(matrix);
    }

    public static final AffineTransform toJavaTransform(SVGMatrix matrix) {
        return new AffineTransform(matrix.getA(), matrix.getB(), matrix.getC(), matrix.getD(), matrix.getE(), matrix.getF());
    }

    public static String toSVGString(AffineTransform matrix) {
        if (matrix == null) {
            return "matrix(1 0 0 1 0 0)";
        }
        StringBuffer sb = new StringBuffer("matrix(");
        double[] m = new double[6];
        matrix.getMatrix(m);
        for (int i = 0; i < m.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(m[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public static AffineTransform toJavaTransform(String string) {
        if (string == null) {
            return null;
        }
        try {
            return AWTTransformProducer.createAffineTransform((String)string);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static final class Decomposition {
        public double tx;
        public double ty;
        public double ro;
        public double scx;
        public double scy;
        public double skx;
        public double sky;

        public Decomposition(SVGMatrix matrix) {
            this(matrix.getA(), matrix.getB(), matrix.getC(), matrix.getD(), matrix.getE(), matrix.getF());
        }

        public Decomposition(double a, double b, double c, double d, double e, double f) {
            double const1 = a * a + b * b;
            double const2 = Math.sqrt(1.0 / const1);
            if (a < 0.0 || b < 0.0) {
                const2 = -const2;
            }
            double tanskx = (a * c + b * d) / const1;
            this.skx = Math.toDegrees(Math.atan(tanskx));
            this.sky = 0.0;
            this.scx = const1 * const2;
            this.scy = (a * d - b * c) * const2;
            this.tx = e;
            this.ty = f;
            this.ro = Math.acos(a * const2);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("skewY(").append(this.sky).append(") translate(").append(this.tx).append(",").append(this.ty).append(") rotate(").append(this.ro).append(") scale(").append(this.scx).append(",").append(this.scy).append(") skewX(").append(this.skx).append(")");
            return sb.toString();
        }
    }
}

