/*
 * Decompiled with CFR 0.152.
 */
package de.intevation.printlayout;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import de.intevation.printlayout.DocumentManager;
import de.intevation.printlayout.I18N;
import de.intevation.printlayout.InfoDialog;
import de.intevation.printlayout.LayoutCanvas;
import de.intevation.printlayout.MapData;
import de.intevation.printlayout.PaperSizes;
import de.intevation.printlayout.PatternExt;
import de.intevation.printlayout.ScaleUpdater;
import de.intevation.printlayout.tools.BoxFactory;
import de.intevation.printlayout.tools.BoxInteractor;
import de.intevation.printlayout.tools.DrawingAttributes;
import de.intevation.printlayout.tools.PickingInteractor;
import de.intevation.printlayout.tools.Tool;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.CachedImageHandlerBase64Encoder;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.GenericImageHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGScrollPane;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.swing.svg.SVGUserAgentGUIAdapter;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLocatable;

public class LayoutFrame
extends JFrame
implements PickingInteractor.PickingListener {
    public static final String A4_SHEET = "resources/a4.svg";
    protected DocumentManager docManager;
    protected LayoutCanvas svgCanvas;
    protected PlugInContext pluginContext;
    protected ArrayList tools;
    protected RemoveAction removeAction;
    protected GroupAction groupAction;
    protected UngroupAction ungroupAction;
    protected AddScalebarAction addScalebarAction;
    protected AddScaletextAction addScaletextAction;
    protected PickingInteractor pickingInteractor;
    protected File lastDirectory;

    public LayoutFrame() {
    }

    public LayoutFrame(PlugInContext pluginContext) {
        super("Print/Layout");
        this.pluginContext = pluginContext;
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.createComponents());
    }

    public JComponent createComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        this.svgCanvas = new LayoutCanvas((SVGUserAgent)new SVGUserAgentGUIAdapter((Component)panel), true, true);
        this.docManager = new DocumentManager(this.svgCanvas);
        this.svgCanvas.setDocumentState(1);
        this.svgCanvas.setBackground(Color.gray);
        this.svgCanvas.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)new SVGDocumentLoaderAdapter(){

            public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
                System.err.println("started");
            }

            public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                System.err.println("completed");
            }
        });
        GVTTreeRendererAdapter r = new GVTTreeRendererAdapter(){
            boolean done;

            public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
            }

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                if (!this.done) {
                    this.done = true;
                    LayoutFrame.this.docManager.generateRulers();
                    LayoutFrame.this.svgCanvas.removeGVTTreeRendererListener((GVTTreeRendererListener)this);
                }
            }
        };
        this.svgCanvas.addGVTTreeRendererListener((GVTTreeRendererListener)r);
        URL url = this.getClass().getResource(A4_SHEET);
        if (url == null) {
            System.err.println("sheet not found");
            return null;
        }
        this.svgCanvas.setURI(url.toString());
        JSVGScrollPane scroller = new JSVGScrollPane((JSVGCanvas)this.svgCanvas);
        JMenu fileMenu = LayoutFrame.createMenu("LayoutFrame.File", "File");
        JMenu editMenu = LayoutFrame.createMenu("LayoutFrame.Edit", "Edit");
        JMenu insertMenu = LayoutFrame.createMenu("LayoutFrame.Insert", "Insert");
        JMenu infoMenu = LayoutFrame.createMenu("LayoutFrame.Help", "Help");
        ExportSVGAction svgExportAction = new ExportSVGAction();
        PDFAction pdfAction = new PDFAction();
        PrintAction printAction = new PrintAction();
        QuitAction quitAction = new QuitAction();
        this.removeAction = new RemoveAction();
        this.groupAction = new GroupAction();
        this.ungroupAction = new UngroupAction();
        ImportImageAction imageImportAction = new ImportImageAction();
        ImportSVGAction svgImportAction = new ImportSVGAction();
        AddMapAction addMapAction = new AddMapAction();
        this.addScalebarAction = new AddScalebarAction();
        this.addScaletextAction = new AddScaletextAction();
        InfoDialogAction infoDialogAction = new InfoDialogAction();
        fileMenu.add(svgExportAction);
        fileMenu.add(pdfAction);
        fileMenu.add(printAction);
        fileMenu.addSeparator();
        fileMenu.add(quitAction);
        editMenu.add(this.removeAction);
        editMenu.add(this.groupAction);
        editMenu.add(this.ungroupAction);
        this.removeAction.setEnabled(false);
        this.groupAction.setEnabled(false);
        this.ungroupAction.setEnabled(false);
        insertMenu.add(addMapAction);
        insertMenu.add(svgImportAction);
        insertMenu.add(imageImportAction);
        insertMenu.add(this.addScalebarAction);
        insertMenu.add(this.addScaletextAction);
        this.addScalebarAction.setEnabled(false);
        this.addScaletextAction.setEnabled(false);
        infoMenu.add(infoDialogAction);
        JMenuBar menubar = new JMenuBar();
        menubar.add(fileMenu);
        menubar.add(editMenu);
        menubar.add(insertMenu);
        menubar.add(infoMenu);
        this.setJMenuBar(menubar);
        panel.add((Component)scroller, "Center");
        this.createTools(panel);
        return panel;
    }

    protected static JMenu createMenu(String key, String def) {
        String label = I18N.getString(key, def);
        JMenu menu = new JMenu(I18N.getName(label));
        menu.setMnemonic(I18N.getMnemonic(label));
        return menu;
    }

    protected void createTools(JPanel panel) {
        DrawingAttributes attributes = new DrawingAttributes();
        attributes.setStrokeColor(Color.black);
        attributes.setFillColor(null);
        attributes.setStroke(new BasicStroke());
        BoxFactory boxFactory = new BoxFactory();
        boxFactory.setDrawingAttributes(attributes);
        BoxInteractor boxInteractor = new BoxInteractor();
        this.pickingInteractor = new PickingInteractor();
        this.pickingInteractor.addPickingListener(this);
        boxInteractor.setFactory(boxFactory);
        boxInteractor.setDocumentManager(this.docManager);
        this.pickingInteractor.setDocumentManager(this.docManager);
        this.addTool(boxInteractor);
        this.addTool(this.pickingInteractor);
        JToolBar toolBar = new JToolBar();
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        JToggleButton boxBnt = new JToggleButton(IconLoader.icon((String)"DrawRectangle.gif"));
        boxBnt.setToolTipText(I18N.getString("LayoutFrame.Draw", "draw"));
        JToggleButton pickBtn = new JToggleButton(IconLoader.icon((String)"Select.gif"));
        pickBtn.setToolTipText(I18N.getString("LayoutFrame.Select", "select"));
        JToggleButton nopBnt = new JToggleButton(IconLoader.icon((String)"BigHand.gif"));
        nopBnt.setToolTipText(I18N.getString("LayoutFrame.Pan", "pan"));
        JToggleButton textBnt = new JToggleButton(IconLoader.icon((String)"LabelOn.gif"));
        textBnt.setToolTipText(I18N.getString("LayoutFrame.Text", "text"));
        textBnt.setEnabled(false);
        boxBnt.setActionCommand(boxInteractor.getToolIdentifier());
        nopBnt.setActionCommand("pan");
        pickBtn.setActionCommand(this.pickingInteractor.getToolIdentifier());
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                LayoutFrame.this.activateTool(ae.getActionCommand());
            }
        };
        boxBnt.addActionListener(listener);
        nopBnt.addActionListener(listener);
        pickBtn.addActionListener(listener);
        ButtonGroup group = new ButtonGroup();
        group.add(nopBnt);
        group.add(pickBtn);
        group.add(boxBnt);
        group.add(textBnt);
        nopBnt.setSelected(true);
        toolBar.add(nopBnt);
        toolBar.add(pickBtn);
        toolBar.add(boxBnt);
        toolBar.add(textBnt);
        ActionMap actionMap = this.svgCanvas.getActionMap();
        Action fullExtendAction = actionMap.get("ResetTransform");
        Action zoomInAction = actionMap.get("ZoomIn");
        Action zoomOutAction = actionMap.get("ZoomOut");
        fullExtendAction.putValue("Name", "1:1");
        zoomInAction.putValue("Name", "+");
        zoomOutAction.putValue("Name", "-");
        JButton fullExtend = new JButton(fullExtendAction);
        JButton zoomIn = new JButton(zoomInAction);
        JButton zoomOut = new JButton(zoomOutAction);
        toolBar.addSeparator();
        toolBar.add(fullExtend);
        toolBar.add(zoomIn);
        toolBar.add(zoomOut);
        toolBar.addSeparator();
        JPanel north = new JPanel(new FlowLayout(3));
        north.add(toolBar);
        panel.add((Component)north, "North");
    }

    public void addTool(Tool tool) {
        if (this.tools == null) {
            this.tools = new ArrayList();
        }
        this.tools.add(tool);
        List overlays = this.svgCanvas.getOverlays();
        overlays.add(0, tool);
        List interactors = this.svgCanvas.getInteractors();
        interactors.add(0, tool);
    }

    public void activateTool(String identifier) {
        if (this.tools == null || identifier == null) {
            return;
        }
        for (int i = this.tools.size() - 1; i >= 0; --i) {
            Tool tool = (Tool)this.tools.get(i);
            tool.setInUse(identifier.equals(tool.getToolIdentifier()));
        }
    }

    public void print() {
        this.docManager.print();
    }

    public void addMap() {
        LayerRenderer layerRenderer;
        Renderer renderer;
        Layer layer;
        int i;
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        AbstractDocument document = (AbstractDocument)impl.createDocument(svgNS, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
        ctx.setGenericImageHandler((GenericImageHandler)new CachedImageHandlerBase64Encoder());
        ctx.setExtensionHandler((ExtensionHandler)new PatternExt());
        SVGGraphics2D svgGenerator = new SVGGraphics2D(ctx, false);
        LayerViewPanel lvp = this.pluginContext.getLayerViewPanel();
        Envelope env = lvp.getViewport().getEnvelopeInModelCoordinates();
        System.err.println(env);
        RenderingManager rms = lvp.getRenderingManager();
        List layers = this.pluginContext.getLayerManager().getVisibleLayers(false);
        int N = layers.size();
        int[] oldMaxFeaures = new int[N];
        for (i = 0; i < N; ++i) {
            layer = (Layer)layers.get(i);
            renderer = rms.getRenderer((Object)layer);
            if (renderer instanceof LayerRenderer) {
                layerRenderer = (LayerRenderer)renderer;
                oldMaxFeaures[i] = layerRenderer.getMaxFeatures();
                layerRenderer.setMaxFeatures(Integer.MAX_VALUE);
                continue;
            }
            System.err.println("unknown renderer type: " + renderer.getClass());
        }
        lvp.repaint();
        lvp.paintComponent((Graphics)svgGenerator);
        for (i = 0; i < N; ++i) {
            layer = (Layer)layers.get(i);
            renderer = rms.getRenderer((Object)layer);
            if (!(renderer instanceof LayerRenderer)) continue;
            layerRenderer = (LayerRenderer)renderer;
            layerRenderer.setMaxFeatures(oldMaxFeaures[i]);
        }
        Envelope xenv = new Envelope(0.0, (double)lvp.getWidth(), 0.0, (double)lvp.getHeight());
        double geo2screen = LayoutFrame.env2env(env, xenv);
        double scale2paper = this.fitToPaper(xenv);
        AffineTransform xform = AffineTransform.getScaleInstance(scale2paper, scale2paper);
        final MapData mapData = new MapData(geo2screen);
        AbstractElement root = (AbstractElement)document.getDocumentElement();
        root = (AbstractElement)svgGenerator.getRoot((Element)root);
        root.setAttributeNS(null, "width", String.valueOf(xenv.getWidth()));
        root.setAttributeNS(null, "height", String.valueOf(xenv.getHeight()));
        root.setAttributeNS(null, "x", "0");
        root.setAttributeNS(null, "y", "0");
        this.docManager.appendSVG(document, xform, false, new DocumentManager.ModificationCallback(){

            public void run(DocumentManager manager, AbstractElement element) {
                String id = element.getAttributeNS(null, "id");
                manager.setData(id, mapData);
            }
        });
    }

    protected double fitToPaper(Envelope env) {
        double[] paper = new double[2];
        this.docManager.getPaperSize(paper);
        double s1 = paper[0] / env.getWidth();
        double s2 = paper[1] / env.getHeight();
        return Math.min(s1, s2);
    }

    protected static double env2env(Envelope env1, Envelope env2) {
        double s1 = env2.getWidth() / env1.getWidth();
        double s2 = env2.getHeight() / env1.getHeight();
        return Math.max(s1, s2);
    }

    protected void exportPDF() {
        JFileChooser fc = new JFileChooser(this.lastDirectory);
        int result = fc.showSaveDialog((Component)((Object)this.docManager.getCanvas()));
        this.lastDirectory = fc.getCurrentDirectory();
        if (result != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        this.docManager.exportPDF(file);
    }

    protected void exportSVG() {
        JFileChooser fc = new JFileChooser(this.lastDirectory);
        int result = fc.showSaveDialog((Component)((Object)this.docManager.getCanvas()));
        this.lastDirectory = fc.getCurrentDirectory();
        if (result != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        this.docManager.exportSVG(file);
    }

    protected static SVGDocument createSheet(String id) {
        return LayoutFrame.createSheet(id, false);
    }

    protected static SVGDocument createSheet(String id, boolean landscape) {
        String text = PaperSizes.sheetForPaperSize(id, landscape);
        if (text == null) {
            return null;
        }
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        try {
            return (SVGDocument)factory.createDocument(null, (Reader)new StringReader(text));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    protected void importSVG() {
        JFileChooser fc = new JFileChooser(this.lastDirectory);
        int result = fc.showOpenDialog((Component)((Object)this.docManager.getCanvas()));
        this.lastDirectory = fc.getCurrentDirectory();
        if (result != 0) {
            return;
        }
        this.docManager.appendSVG(fc.getSelectedFile());
    }

    protected void importImage() {
        JFileChooser fc = new JFileChooser(this.lastDirectory);
        int result = fc.showOpenDialog((Component)((Object)this.docManager.getCanvas()));
        this.lastDirectory = fc.getCurrentDirectory();
        if (result != 0) {
            return;
        }
        this.docManager.appendImage(fc.getSelectedFile());
    }

    protected void removeSelected() {
        String[] ids = this.pickingInteractor.getSelectedIDs();
        if (ids != null) {
            this.pickingInteractor.clearSelection();
            this.docManager.removeIDs(ids);
        }
    }

    protected void group() {
        String[] ids = this.pickingInteractor.getSelectedIDs();
        if (ids != null) {
            this.pickingInteractor.clearSelection();
            this.docManager.groupIDs(ids);
        }
    }

    protected void ungroup() {
        String[] ids = this.pickingInteractor.getSelectedIDs();
        if (ids != null) {
            this.pickingInteractor.clearSelection();
            this.docManager.ungroupIDs(ids);
        }
    }

    protected void addScaleText() {
        final String[] ids = this.pickingInteractor.getSelectedIDs();
        if (ids == null || ids.length < 1) {
            return;
        }
        this.docManager.addText("", new DocumentManager.ModificationCallback(){

            public void run(DocumentManager manager, AbstractElement el) {
                SVGDocument doc = manager.getSVGDocument();
                SVGLocatable loc = (SVGLocatable)doc.getElementById(ids[0]);
                if (loc == null) {
                    return;
                }
                String id = el.getAttributeNS(null, "id");
                ScaleUpdater updater = new ScaleUpdater(id);
                manager.addChangeListener(ids[0], updater);
                updater.elementTransformed(loc, manager);
            }
        });
    }

    public void selectionChanged(PickingInteractor.PickingEvent evt) {
        PickingInteractor pi = (PickingInteractor)evt.getSource();
        String[] ids = pi.getSelectedIDs();
        int N = pi.numSelections();
        if (this.removeAction != null) {
            this.removeAction.setEnabled(N > 0 && !this.docManager.hasRecursiveChangeListeners(ids));
        }
        if (this.groupAction != null) {
            this.groupAction.setEnabled(N > 1);
        }
        if (this.ungroupAction != null) {
            this.ungroupAction.setEnabled(N > 0);
        }
        if (this.addScaletextAction != null) {
            this.addScaletextAction.setEnabled(N == 1 && this.docManager.getData(ids[0]) instanceof MapData);
        }
        if (this.addScalebarAction != null) {
            this.addScalebarAction.setEnabled(N == 1);
        }
    }

    protected void notImplementedYet() {
        JOptionPane.showMessageDialog(this, I18N.getString("LayoutFrame.NotImplementedYet", "Not implemented, yet!"), I18N.getString("LayoutFrame.Warning", "Warning"), 2);
    }

    private class InfoDialogAction
    extends AbstractAction {
        InfoDialogAction() {
            super(I18N.getName(I18N.getString("LayoutFrame.ShowAboutDialog", "&About...")));
            this.putValue("MnemonicKey", I18N.getMnemonic(I18N.getString("LayoutFrame.ShowAboutDialog", "&About...")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl A"));
        }

        public void actionPerformed(ActionEvent ae) {
            InfoDialog.showDialog(LayoutFrame.this);
        }
    }

    private class AddScaletextAction
    extends AbstractAction {
        AddScaletextAction() {
            super(I18N.getName(I18N.getString("LayoutFrame.AddScaleText", "Add S&caletext")));
            this.putValue("MnemonicKey", I18N.getMnemonic(I18N.getString("LayoutFrame.AddScaleText", "Add S&caletext")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl T"));
        }

        public void actionPerformed(ActionEvent ae) {
            LayoutFrame.this.addScaleText();
        }
    }

    private class AddScalebarAction
    extends AbstractAction {
        AddScalebarAction() {
            super(I18N.getName(I18N.getString("LayoutFrame.AddScaleBar", "Add Scale&bar")));
            this.putValue("MnemonicKey", I18N.getMnemonic(I18N.getString("LayoutFrame.AddScaleBar", "Add Scale&bar")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl B"));
        }

        public void actionPerformed(ActionEvent ae) {
            LayoutFrame.this.notImplementedYet();
        }
    }

    private class UngroupAction
    extends AbstractAction {
        UngroupAction() {
            super(I18N.getName(I18N.getString("LayoutFrame.Ungroup", "Ungroup")));
            this.putValue("MnemonicKey", I18N.getMnemonic(I18N.getString("LayoutFrame.Ungroup", "Ungroup")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl U"));
        }

        public void actionPerformed(ActionEvent ae) {
            LayoutFrame.this.ungroup();
        }
    }

    private class GroupAction
    extends AbstractAction {
        GroupAction() {
            super(I18N.getName(I18N.getString("LayoutFrame.Group", "Group")));
            this.putValue("MnemonicKey", I18N.getMnemonic(I18N.getString("LayoutFrame.Group", "Group")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl G"));
        }

        public void actionPerformed(ActionEvent ae) {
            LayoutFrame.this.group();
        }
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction() {
            super(I18N.getName(I18N.getString("LayoutFrame.Remove", "Remove")));
            this.putValue("MnemonicKey", I18N.getMnemonic(I18N.getString("LayoutFrame.Remove", "Remove")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        }

        public void actionPerformed(ActionEvent ae) {
            LayoutFrame.this.removeSelected();
        }
    }

    private class QuitAction
    extends AbstractAction {
        QuitAction() {
            super(I18N.getName(I18N.getString("LayoutFrame.Close", "Close")));
            this.putValue("MnemonicKey", I18N.getMnemonic(I18N.getString("LayoutFrame.Close", "Close")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control C"));
        }

        public void actionPerformed(ActionEvent ae) {
            LayoutFrame.this.dispose();
        }
    }

    private class AddMapAction
    extends AbstractAction {
        AddMapAction() {
            super(I18N.getName(I18N.getString("LayoutFrame.AddMap", "Add Map")));
            this.putValue("MnemonicKey", I18N.getMnemonic(I18N.getString("LayoutFrame.AddMap", "Add Map")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control M"));
        }

        public void actionPerformed(ActionEvent ae) {
            LayoutFrame.this.addMap();
        }
    }

    private class ExportSVGAction
    extends AbstractAction {
        ExportSVGAction() {
            super(I18N.getName(I18N.getString("LayoutFrame.ExportSVG", "Export SVG...")));
            this.putValue("MnemonicKey", I18N.getMnemonic(I18N.getString("LayoutFrame.ExportSVG", "Export SVG...")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control E"));
        }

        public void actionPerformed(ActionEvent ae) {
            LayoutFrame.this.exportSVG();
        }
    }

    private class ImportSVGAction
    extends AbstractAction {
        ImportSVGAction() {
            super(I18N.getName(I18N.getString("LayoutFrame.ImportSVG", "Import SVG...")));
            this.putValue("MnemonicKey", I18N.getMnemonic(I18N.getString("LayoutFrame.ImportSVG", "Import SVG...")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control V"));
        }

        public void actionPerformed(ActionEvent ae) {
            LayoutFrame.this.importSVG();
        }
    }

    private class ImportImageAction
    extends AbstractAction {
        ImportImageAction() {
            super(I18N.getName(I18N.getString("LayoutFrame.ImportImage", "Import Image...")));
            this.putValue("MnemonicKey", I18N.getMnemonic(I18N.getString("LayoutFrame.ImportImage", "Import Image...")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control I"));
        }

        public void actionPerformed(ActionEvent ae) {
            LayoutFrame.this.importImage();
        }
    }

    private class PDFAction
    extends AbstractAction {
        PDFAction() {
            super(I18N.getName(I18N.getString("LayoutFrame.ExportPDF", "Export PDF...")));
            this.putValue("MnemonicKey", I18N.getMnemonic(I18N.getString("LayoutFrame.ExportPDF", "Export PDF...")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control X"));
        }

        public void actionPerformed(ActionEvent ae) {
            LayoutFrame.this.exportPDF();
        }
    }

    private class PrintAction
    extends AbstractAction {
        PrintAction() {
            super(I18N.getName(I18N.getString("LayoutFrame.Print", "Print...")));
            this.putValue("MnemonicKey", I18N.getMnemonic(I18N.getString("LayoutFrame.Print", "Print...")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control P"));
        }

        public void actionPerformed(ActionEvent ae) {
            LayoutFrame.this.print();
        }
    }
}

