/*
 * Decompiled with CFR 0.152.
 */
package de.intevation.printlayout;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18N {
    private static final ResourceBundle I18N = ResourceBundle.getBundle("de.intevation.printlayout.i18n.messages");

    private I18N() {
    }

    public static String getString(String key) {
        return I18N.getString(key);
    }

    public static String getString(String key, String def) {
        try {
            return I18N.getString(key);
        }
        catch (MissingResourceException mre) {
            return def;
        }
    }

    public static String getName(String label) {
        StringBuffer sb = new StringBuffer();
        boolean lastWasQuoteAmp = false;
        int N = label.length();
        for (int i = 0; i < N; ++i) {
            if (label.charAt(i) == '&' && lastWasQuoteAmp) {
                lastWasQuoteAmp = false;
                sb.append('&');
                continue;
            }
            if (label.charAt(i) == '&') {
                lastWasQuoteAmp = true;
                continue;
            }
            lastWasQuoteAmp = false;
            sb.append(label.charAt(i));
        }
        return sb.toString();
    }

    public static Integer getMnemonic(String label) {
        Character c = null;
        boolean lastWasQuoteAmp = false;
        int N = label.length();
        for (int i = 0; i < N; ++i) {
            if (lastWasQuoteAmp && label.charAt(i) == '&') {
                lastWasQuoteAmp = false;
                continue;
            }
            if (lastWasQuoteAmp && Character.isLetter(label.charAt(i))) {
                c = new Character(Character.toUpperCase(label.charAt(i)));
                break;
            }
            if (lastWasQuoteAmp) {
                lastWasQuoteAmp = false;
                continue;
            }
            if (label.charAt(i) != '&') continue;
            lastWasQuoteAmp = true;
        }
        if (c != null) {
            return new Integer(c.charValue());
        }
        return null;
    }
}

