/*
 * Decompiled with CFR 0.152.
 */
package de.intevation.printlayout;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import org.apache.batik.dom.AbstractElement;

public class ExtraData
implements Serializable {
    protected HashMap id2entry = new HashMap();

    public void remove(Object source, AbstractElement element) {
        String id = element.getAttributeNS(null, "id");
        if (id == null) {
            return;
        }
        Entry entry = (Entry)this.id2entry.remove(id);
        if (entry == null) {
            return;
        }
        entry.remove(source, element);
    }

    public void fireElementTransformed(Object source, AbstractElement element) {
        String id = element.getAttributeNS(null, "id");
        if (id == null) {
            return;
        }
        Entry entry = (Entry)this.id2entry.get(id);
        if (entry == null) {
            return;
        }
        entry.fireElementTransformed(source, element);
    }

    public HashMap getID2Entry() {
        return this.id2entry;
    }

    public void setID2Entry(HashMap id2entry) {
        this.id2entry = id2entry;
    }

    public void setData(String id, Object data) {
        Entry entry = (Entry)this.id2entry.get(id);
        if (entry == null) {
            entry = new Entry();
            this.id2entry.put(id, entry);
        }
        entry.setData(data);
    }

    public Object getData(String id) {
        Entry entry = (Entry)this.id2entry.get(id);
        return entry != null ? entry.getData() : null;
    }

    public Entry getOrCreateEntry(String id) {
        Entry entry = (Entry)this.id2entry.get(id);
        if (entry == null) {
            entry = new Entry();
            this.id2entry.put(id, entry);
        }
        return entry;
    }

    public void addRemoveListener(String id, RemoveListener l) {
        Entry entry = (Entry)this.id2entry.get(id);
        if (entry == null) {
            entry = new Entry();
            this.id2entry.put(id, entry);
        }
        entry.addRemoveListener(l);
    }

    public void removeRemoveListener(String id, RemoveListener l) {
        Entry entry = (Entry)this.id2entry.get(id);
        if (entry == null) {
            return;
        }
        entry.removeRemoveListener(l);
        if (entry.allEmpty()) {
            this.id2entry.remove(id);
        }
    }

    public void addChangeListener(String id, ChangeListener l) {
        Entry entry = (Entry)this.id2entry.get(id);
        if (entry == null) {
            entry = new Entry();
            this.id2entry.put(id, entry);
        }
        entry.addChangeListener(l);
    }

    public void removeChangeListener(String id, ChangeListener l) {
        Entry entry = (Entry)this.id2entry.get(id);
        if (entry == null) {
            return;
        }
        entry.removeChangeListener(l);
        if (entry.allEmpty()) {
            this.id2entry.remove(id);
        }
    }

    public boolean hasChangeListeners(String id) {
        return this.id2entry.containsKey(id);
    }

    public static class Entry
    implements Serializable {
        protected ArrayList removeListeners;
        protected ArrayList changeListeners;
        protected Object data;

        public ArrayList getRemoveListeners() {
            return this.removeListeners;
        }

        public void setRemoveListeners(ArrayList removeListeners) {
            this.removeListeners = removeListeners;
        }

        public ArrayList getChangeListeners() {
            return this.changeListeners;
        }

        public void setChangeListeners(ArrayList changeListeners) {
            this.changeListeners = changeListeners;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public Object getData() {
            return this.data;
        }

        public boolean allEmpty() {
            return this.removeListeners == null && this.changeListeners == null && this.data == null;
        }

        public void addRemoveListener(RemoveListener l) {
            if (this.removeListeners == null) {
                this.removeListeners = new ArrayList(3);
            }
            if (!this.removeListeners.contains(l)) {
                this.removeListeners.add(l);
            }
        }

        public void removeRemoveListener(RemoveListener l) {
            if (this.removeListeners != null && this.removeListeners.remove(l) && this.removeListeners.isEmpty()) {
                this.removeListeners = null;
            }
        }

        public void addChangeListener(ChangeListener l) {
            if (this.changeListeners == null) {
                this.changeListeners = new ArrayList(3);
            }
            if (!this.changeListeners.contains(l)) {
                this.changeListeners.add(l);
            }
        }

        public void removeChangeListener(ChangeListener l) {
            if (this.changeListeners != null && this.changeListeners.remove(l) && this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }

        protected void fireElementRemoved(Object source, AbstractElement element) {
            if (this.removeListeners != null) {
                Event event = new Event(source, element);
                for (int i = this.removeListeners.size() - 1; i >= 0; --i) {
                    ((RemoveListener)this.removeListeners.get(i)).elementRemoved(event);
                }
            }
        }

        protected void fireElementTransformed(Object source, AbstractElement element) {
            if (this.changeListeners != null) {
                Event event = new Event(source, element);
                for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                    ((ChangeListener)this.changeListeners.get(i)).elementTransformed(event);
                }
            }
        }

        public void clear() {
            if (this.removeListeners != null) {
                ArrayList rl = this.removeListeners;
                this.removeListeners = null;
                rl.clear();
            }
            if (this.changeListeners != null) {
                ArrayList cl = this.changeListeners;
                this.changeListeners = null;
                cl.clear();
            }
            this.data = null;
        }

        public void remove(Object source, AbstractElement element) {
            this.fireElementRemoved(source, element);
            this.clear();
        }
    }

    public static interface RemoveListener
    extends Serializable,
    EventListener {
        public void elementRemoved(Event var1);
    }

    public static interface ChangeListener
    extends Serializable,
    EventListener {
        public void elementTransformed(Event var1);
    }

    public static class Event
    extends EventObject {
        protected AbstractElement element;

        public Event(Object source, AbstractElement element) {
            super(source);
            this.element = element;
        }

        public AbstractElement getElement() {
            return this.element;
        }
    }
}

