/*
 * Decompiled with CFR 0.152.
 */
package de.intevation.printlayout;

import de.intevation.printlayout.ExtraData;
import de.intevation.printlayout.GeometricMath;
import de.intevation.printlayout.LayoutCanvas;
import de.intevation.printlayout.MatrixTools;
import de.intevation.printlayout.TypoUnits;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractDocumentFragment;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.ImageHandlerBase64Encoder;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.print.PrintTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.fop.svg.PDFTranscoder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGGElement;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGRect;

public class DocumentManager {
    public static final String DOCUMENT_SHEET = "viewer-layout-sheet-svg";
    public static final String DOCUMENT_BELOW = "viewer-layout-below";
    public static final String OBJECT_ID = "viewer-layout-id";
    public static final String OBJECT_ID_LEAF = "viewer-layout-id-leaf";
    protected LayoutCanvas svgCanvas;
    protected int objectID;
    protected ExtraData extraData = new ExtraData();

    public DocumentManager() {
    }

    public DocumentManager(LayoutCanvas svgCanvas) {
        this();
        this.svgCanvas = svgCanvas;
    }

    public void addChangeListener(String id, ExtraData.ChangeListener listener) {
        this.extraData.addChangeListener(id, listener);
    }

    public void removeChangeListener(String id, ExtraData.ChangeListener listener) {
        this.extraData.removeChangeListener(id, listener);
    }

    public void addRemoveListener(String id, ExtraData.RemoveListener listener) {
        this.extraData.addRemoveListener(id, listener);
    }

    public void removeRemoveListener(String id, ExtraData.RemoveListener listener) {
        this.extraData.removeRemoveListener(id, listener);
    }

    public ExtraData.Entry getOrCreateEntry(String id) {
        return this.extraData.getOrCreateEntry(id);
    }

    public void setData(String id, Object data) {
        this.extraData.setData(id, data);
    }

    public Object getData(String id) {
        return this.extraData.getData(id);
    }

    public boolean hasChangeListeners(String[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (!this.extraData.hasChangeListeners(ids[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasChangeListeners(String id) {
        return this.extraData.hasChangeListeners(id);
    }

    public LayoutCanvas getCanvas() {
        return this.svgCanvas;
    }

    public SVGDocument getSVGDocument() {
        return this.svgCanvas.getSVGDocument();
    }

    public void getPaperSize(double[] size) {
        SVGDocument document = this.svgCanvas.getSVGDocument();
        AbstractElement sheet = (AbstractElement)document.getElementById(DOCUMENT_SHEET);
        if (sheet == null) {
            System.err.println("sheet not found");
            return;
        }
        try {
            size[0] = Double.parseDouble(sheet.getAttributeNS(null, "width"));
            size[1] = Double.parseDouble(sheet.getAttributeNS(null, "height"));
        }
        catch (NumberFormatException nfe) {
            size[0] = 210.0;
            size[1] = 297.0;
        }
    }

    public void setDocument(SVGDocument document) {
        this.svgCanvas.installDocument(document);
    }

    public void modifyDocumentLater(final DocumentModifier modifier) {
        UpdateManager um = this.svgCanvas.getUpdateManager();
        if (um == null) {
            System.err.println("before first rendering finished");
            return;
        }
        um.getUpdateRunnableQueue().invokeLater(new Runnable(){

            public void run() {
                modifier.run(DocumentManager.this);
            }
        });
    }

    public Object modifyDocumentNow(final DocumentModifier modifier) {
        UpdateManager um = this.svgCanvas.getUpdateManager();
        if (um == null) {
            System.err.println("before first rendering finbished");
            return null;
        }
        final Object[] result = new Object[1];
        try {
            um.getUpdateRunnableQueue().invokeAndWait(new Runnable(){

                public void run() {
                    result[0] = modifier.run(DocumentManager.this);
                }
            });
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            return null;
        }
        return result[0];
    }

    public void addText(String text) {
        this.addText(text, null);
    }

    public void addText(final String text, final ModificationCallback callback) {
        this.modifyDocumentLater(new DocumentModifier(){

            public Object run(DocumentManager documentManager) {
                SVGDocument document = documentManager.getSVGDocument();
                String svgNS = "http://www.w3.org/2000/svg";
                AbstractElement textElement = (AbstractElement)document.createElementNS(svgNS, "text");
                textElement.setTextContent(text);
                AbstractElement xform = (AbstractElement)document.createElementNS(svgNS, "g");
                xform.setAttributeNS(null, "id", DocumentManager.this.uniqueObjectID());
                xform.setAttributeNS(null, "transform", "matrix(1 0 0 1 0 0)");
                xform.appendChild((Node)textElement);
                AbstractElement sheet = (AbstractElement)document.getElementById(DocumentManager.DOCUMENT_SHEET);
                sheet.appendChild((Node)xform);
                if (callback != null) {
                    callback.run(documentManager, xform);
                }
                return null;
            }
        });
    }

    public void exportSVG(final File file) {
        UpdateManager um = this.svgCanvas.getUpdateManager();
        if (um == null) {
            System.err.println("before first rendering finished");
            return;
        }
        um.getUpdateRunnableQueue().invokeLater(new Runnable(){

            public void run() {
                DocumentManager.this.exportSVGwithinUM(file);
            }
        });
    }

    public void exportSVGwithinUM(File file) {
        AbstractDocument innerSVG = this.isolateInnerDocument();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StreamResult outputTarget = new StreamResult(file);
            DOMSource xmlSource = new DOMSource((Node)innerSVG);
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("cdata-section-elements", "");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlSource, outputTarget);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public AbstractDocument isolateInnerDocument() {
        AbstractDocument document = (AbstractDocument)this.svgCanvas.getSVGDocument();
        AbstractElement root = (AbstractElement)document.getDocumentElement();
        AbstractElement sheet = (AbstractElement)document.getElementById(DOCUMENT_SHEET);
        if (sheet == null) {
            System.err.println("sheet not found");
            return null;
        }
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        AbstractDocument newDocument = (AbstractDocument)impl.createDocument(svgNS, "svg", null);
        NodeList children = sheet.getChildNodes();
        AbstractElement newRoot = (AbstractElement)newDocument.getDocumentElement();
        AbstractDocumentFragment fragment = (AbstractDocumentFragment)newDocument.createDocumentFragment();
        int N = children.getLength();
        for (int i = 0; i < N; ++i) {
            AbstractNode child = (AbstractNode)children.item(i);
            fragment.appendChild(newDocument.importNode((Node)child, true));
        }
        newRoot.appendChild((Node)fragment);
        newRoot.setAttributeNS(null, "width", sheet.getAttributeNS(null, "width") + "mm");
        newRoot.setAttributeNS(null, "height", sheet.getAttributeNS(null, "height") + "mm");
        newRoot.setAttributeNS(null, "viewBox", "0 0 " + sheet.getAttributeNS(null, "width") + " " + sheet.getAttributeNS(null, "height"));
        return newDocument;
    }

    public void appendImage(File file) {
        try {
            final BufferedImage image = ImageIO.read(file);
            this.modifyDocumentLater(new DocumentModifier(){

                public Object run(DocumentManager documentManager) {
                    SVGDocument document = documentManager.getSVGDocument();
                    String svgNS = "http://www.w3.org/2000/svg";
                    AbstractElement img = (AbstractElement)document.createElementNS(svgNS, "image");
                    ImageHandlerBase64Encoder handler = new ImageHandlerBase64Encoder();
                    try {
                        handler.handleHREF((RenderedImage)image, (Element)img, SVGGeneratorContext.createDefault((Document)document));
                    }
                    catch (SVGGraphics2DIOException g2ioe) {
                        g2ioe.printStackTrace();
                        return null;
                    }
                    int width = image.getWidth();
                    int height = image.getHeight();
                    double[] paper = new double[2];
                    DocumentManager.this.getPaperSize(paper);
                    img.setAttributeNS(null, "width", String.valueOf(width));
                    img.setAttributeNS(null, "height", String.valueOf(height));
                    img.setAttributeNS(null, "x", "0");
                    img.setAttributeNS(null, "y", "0");
                    AbstractElement group = (AbstractElement)document.createElementNS(svgNS, "g");
                    double s1 = paper[0] / (double)width;
                    double s2 = paper[1] / (double)height;
                    double scale = Math.min(s1, s2);
                    AffineTransform xfrom = AffineTransform.getScaleInstance(scale, scale);
                    group.setAttributeNS(null, "transform", MatrixTools.toSVGString(xfrom));
                    group.setAttributeNS(null, "id", documentManager.uniqueObjectID());
                    group.appendChild((Node)img);
                    AbstractElement sheet = (AbstractElement)document.getElementById(DocumentManager.DOCUMENT_SHEET);
                    sheet.appendChild((Node)group);
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
    }

    public void appendSVG(File file) {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        try {
            String uri = file.toURL().toString();
            this.appendSVG((AbstractDocument)factory.createDocument(uri), null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void appendSVG(AbstractDocument document, AffineTransform xform) {
        this.appendSVG(document, xform, true, null);
    }

    public void appendSVG(AbstractDocument document, AffineTransform xform, boolean adjustView) {
        this.appendSVG(document, xform, adjustView);
    }

    public void appendSVG(final AbstractDocument document, final AffineTransform xform, final boolean adjustView, final ModificationCallback callback) {
        UpdateManager um = this.svgCanvas.getUpdateManager();
        if (um == null) {
            System.err.println("before first rendering finished");
            return;
        }
        um.getUpdateRunnableQueue().invokeLater(new Runnable(){

            public void run() {
                DocumentManager.this.appendSVGwithinUM(document, xform, adjustView, callback);
            }
        });
    }

    protected static Rectangle2D.Double pseudoViewBox(AbstractElement svg) {
        return new Rectangle2D.Double(0.0, 0.0, Double.parseDouble(svg.getAttributeNS(null, "width")), Double.parseDouble(svg.getAttributeNS(null, "height")));
    }

    protected static void setAttrib(AbstractElement svg, String field, double px2mm, double defaultVal) {
        try {
            double[] v = new double[1];
            TypoUnits.stringToMM(svg.getAttributeNS(null, field), px2mm, defaultVal, v);
            svg.setAttributeNS(null, field, String.valueOf(v[0]));
        }
        catch (NumberFormatException nfe) {
            svg.setAttributeNS(null, field, String.valueOf(defaultVal));
        }
    }

    protected void adaptUnits(AbstractElement svg, AbstractElement master) {
        double px2mm;
        Rectangle2D.Double viewBox = DocumentManager.pseudoViewBox(master);
        UserAgent ua = this.svgCanvas.getUserAgent();
        if (ua == null) {
            System.err.println("no user agent found");
            px2mm = 1.0;
        } else {
            px2mm = ua.getPixelUnitToMillimeter();
        }
        DocumentManager.setAttrib(svg, "x", px2mm, ((RectangularShape)viewBox).getX());
        DocumentManager.setAttrib(svg, "y", px2mm, ((RectangularShape)viewBox).getY());
        DocumentManager.setAttrib(svg, "width", px2mm, ((RectangularShape)viewBox).getWidth());
        DocumentManager.setAttrib(svg, "height", px2mm, ((RectangularShape)viewBox).getHeight());
    }

    public String uniqueObjectID() {
        return this.uniqueObjectID(true);
    }

    public String uniqueObjectID(boolean leaf) {
        String idString;
        String prefix = leaf ? OBJECT_ID_LEAF : OBJECT_ID;
        AbstractDocument document = (AbstractDocument)this.svgCanvas.getSVGDocument();
        do {
            idString = prefix + this.objectID;
            ++this.objectID;
        } while (document.getElementById(idString) != null);
        return idString;
    }

    public void print() {
        this.modifyDocumentLater(new DocumentModifier(){

            public Object run(DocumentManager documentManager) {
                SVGDocument document = documentManager.getSVGDocument();
                final PrintTranscoder transcoder = new PrintTranscoder();
                TranscoderInput input = new TranscoderInput((Document)DocumentManager.this.isolateInnerDocument());
                transcoder.transcode(input, null);
                PrinterJob job = PrinterJob.getPrinterJob();
                PageFormat pageFomat = new PageFormat();
                double[] size = new double[2];
                DocumentManager.this.getPaperSize(size);
                Paper paper = new Paper();
                double width = TypoUnits.mm2in(size[0]) * 72.0;
                double height = TypoUnits.mm2in(size[1]) * 72.0;
                paper.setSize(width, height);
                pageFomat.setPaper(paper);
                job.setPrintable(new Printable(){

                    public int print(Graphics g, PageFormat pf, int page) {
                        Graphics2D g2d = (Graphics2D)g;
                        AffineTransform trans = AffineTransform.getTranslateInstance(-pf.getImageableX(), -pf.getImageableY());
                        double sw = pf.getWidth() / pf.getImageableWidth();
                        double sh = pf.getHeight() / pf.getImageableHeight();
                        AffineTransform scale = AffineTransform.getScaleInstance(sw, sh);
                        trans.concatenate(scale);
                        AffineTransform old = g2d.getTransform();
                        old.concatenate(trans);
                        g2d.setTransform(old);
                        return transcoder.print((Graphics)g2d, pf, page);
                    }
                });
                if (job.printDialog()) {
                    System.err.println("printing ...");
                    try {
                        job.print();
                    }
                    catch (PrinterException pe) {
                        pe.printStackTrace();
                    }
                } else {
                    System.err.println("print cancelled");
                }
                return null;
            }
        });
    }

    public void exportPDF(final File file) {
        this.modifyDocumentLater(new DocumentModifier(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run(DocumentManager documentManager) {
                TranscoderInput input = new TranscoderInput((Document)DocumentManager.this.isolateInnerDocument());
                OutputStream out = null;
                try {
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    PDFTranscoder pdfTrancoder = new PDFTranscoder();
                    TranscoderOutput output = new TranscoderOutput(out);
                    pdfTrancoder.transcode(input, output);
                    out.flush();
                }
                catch (TranscoderException te) {
                    te.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioe) {}
                        out = null;
                    }
                }
                return null;
            }
        });
    }

    public void appendSVGwithinUM(AbstractDocument newDocument, AffineTransform matrix, boolean adjustView, ModificationCallback modificationCallback) {
        AbstractDocument document = (AbstractDocument)this.svgCanvas.getSVGDocument();
        AbstractElement root = (AbstractElement)document.getElementById(DOCUMENT_SHEET);
        if (adjustView) {
            this.adaptUnits((AbstractElement)newDocument.getDocumentElement(), root);
        }
        String svgNS = "http://www.w3.org/2000/svg";
        AbstractElement xform = (AbstractElement)document.createElementNS(svgNS, "g");
        xform.setAttributeNS(null, "transform", matrix == null ? "matrix(1 0 0 1 0 0)" : MatrixTools.toSVGString(matrix));
        xform.setAttributeNS(null, "id", this.uniqueObjectID());
        AbstractNode node = (AbstractNode)document.importNode((Node)newDocument.getDocumentElement(), true, false);
        xform.appendChild((Node)node);
        root.appendChild((Node)xform);
        if (modificationCallback != null) {
            modificationCallback.run(this, xform);
        }
    }

    protected static boolean visit(AbstractElement element, ElementVisitor visitor) {
        Stack<Object> stack = new Stack<Object>();
        stack.push(element);
        while (!stack.empty()) {
            element = (AbstractElement)stack.pop();
            String id = element.getAttributeNS(null, "id");
            if (id != null && id.startsWith(OBJECT_ID)) {
                if (!visitor.visit(element)) {
                    return false;
                }
                if (id.startsWith(OBJECT_ID_LEAF)) continue;
            }
            if (!element.hasChildNodes()) continue;
            NodeList children = element.getChildNodes();
            for (int i = children.getLength() - 1; i >= 0; --i) {
                Node node = children.item(i);
                if (!(node instanceof AbstractElement)) continue;
                stack.push(node);
            }
        }
        return true;
    }

    public boolean hasRecursiveChangeListeners(String[] ids) {
        if (ids == null) {
            return false;
        }
        SVGDocument document = this.getSVGDocument();
        for (int i = 0; i < ids.length; ++i) {
            AbstractElement element = (AbstractElement)document.getElementById(ids[i]);
            if (element == null || !this.hasRecursiveChangeListeners(element)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRecursiveChangeListeners(AbstractElement element) {
        final boolean[] has = new boolean[1];
        DocumentManager.visit(element, new ElementVisitor(){

            public boolean visit(AbstractElement element) {
                String id = element.getAttributeNS(null, "id");
                if (id != null && DocumentManager.this.hasChangeListeners(id)) {
                    has[0] = true;
                    return false;
                }
                return true;
            }
        });
        return has[0];
    }

    protected void recursiveRemove(AbstractElement element) {
        DocumentManager.visit(element, new ElementVisitor(){

            public boolean visit(AbstractElement element) {
                DocumentManager.this.extraData.remove(DocumentManager.this, element);
                return true;
            }
        });
    }

    protected void recursiveTransform(AbstractElement element) {
        DocumentManager.visit(element, new ElementVisitor(){

            public boolean visit(AbstractElement element) {
                DocumentManager.this.extraData.fireElementTransformed(DocumentManager.this, element);
                return true;
            }
        });
    }

    public void removeIDs(final String[] ids) {
        this.modifyDocumentLater(new DocumentModifier(){

            public Object run(DocumentManager documentManager) {
                SVGDocument document = documentManager.getSVGDocument();
                for (int i = 0; i < ids.length; ++i) {
                    AbstractElement element = (AbstractElement)document.getElementById(ids[i]);
                    if (element == null || DocumentManager.this.hasRecursiveChangeListeners(element)) continue;
                    AbstractElement parent = (AbstractElement)element.getParentNode();
                    if (parent != null) {
                        parent.removeChild((Node)element);
                    }
                    DocumentManager.this.recursiveRemove(element);
                }
                return null;
            }
        });
    }

    public void groupIDs(final String[] ids) {
        if (ids == null || ids.length < 2) {
            return;
        }
        this.modifyDocumentLater(new DocumentModifier(){

            public Object run(DocumentManager documentManager) {
                SVGDocument document = documentManager.getSVGDocument();
                AbstractElement sheet = (AbstractElement)document.getElementById(DocumentManager.DOCUMENT_SHEET);
                ArrayList<AbstractElement> children = new ArrayList<AbstractElement>();
                for (int i = 0; i < ids.length; ++i) {
                    AbstractElement parent;
                    AbstractElement element = (AbstractElement)document.getElementById(ids[i]);
                    if (element == null || (parent = (AbstractElement)element.getParentNode()) != sheet) continue;
                    parent.removeChild((Node)element);
                    children.add(element);
                }
                int N = children.size();
                if (N == 0) {
                    return null;
                }
                String svgNS = "http://www.w3.org/2000/svg";
                AbstractElement group = (AbstractElement)document.createElementNS(svgNS, "g");
                group.setAttributeNS(null, "transform", "matrix(1 0 0 1 0 0)");
                group.setAttributeNS(null, "id", DocumentManager.this.uniqueObjectID(false));
                for (int i = 0; i < N; ++i) {
                    group.appendChild((Node)((AbstractElement)children.get(i)));
                }
                sheet.appendChild((Node)group);
                return null;
            }
        });
    }

    public void ungroupIDs(final String[] ids) {
        this.modifyDocumentLater(new DocumentModifier(){

            public Object run(DocumentManager documentManager) {
                block0: for (int j = 0; j < ids.length; ++j) {
                    NodeList children;
                    int N;
                    AbstractElement parent;
                    SVGDocument document;
                    AbstractElement element;
                    String id = ids[j];
                    if (id == null || !id.startsWith(DocumentManager.OBJECT_ID) || (element = (AbstractElement)(document = documentManager.getSVGDocument()).getElementById(id)) == null || !(element instanceof SVGGElement) || (parent = (AbstractElement)element.getParentNode()) == null || !parent.getAttributeNS(null, "id").equals(DocumentManager.DOCUMENT_SHEET) || (N = (children = element.getChildNodes()).getLength()) < 2) continue;
                    ArrayList<AbstractElement> list = new ArrayList<AbstractElement>(N);
                    for (int i = 0; i < N; ++i) {
                        String idx;
                        AbstractElement child = (AbstractElement)children.item(i);
                        if (!(child instanceof SVGGElement) || (idx = child.getAttributeNS(null, "id")) == null || !idx.startsWith(DocumentManager.OBJECT_ID)) continue block0;
                        list.add(child);
                    }
                    parent.removeChild((Node)element);
                    String xformS = element.getAttributeNS(null, "transform");
                    AffineTransform xform = xformS != null ? MatrixTools.toJavaTransform(xformS) : new AffineTransform();
                    for (int i = 0; i < N; ++i) {
                        AbstractElement child = (AbstractElement)list.get(i);
                        element.removeChild((Node)child);
                        xformS = child.getAttributeNS(null, "transform");
                        if (xformS == null) {
                            child.setAttributeNS(null, "transform", MatrixTools.toSVGString(xform));
                        } else {
                            AffineTransform yform = MatrixTools.toJavaTransform(xformS);
                            yform.preConcatenate(xform);
                            child.setAttributeNS(null, "transform", MatrixTools.toSVGString(yform));
                        }
                        parent.appendChild((Node)child);
                    }
                }
                return null;
            }
        });
    }

    public void translateIDs(final String[] ids, final Point2D screenDelta) {
        if (ids == null || ids.length == 0) {
            return;
        }
        this.modifyDocumentLater(new DocumentModifier(){

            public Object run(DocumentManager documentManager) {
                SVGDocument document = documentManager.getSVGDocument();
                Point2D.Double delta = new Point2D.Double();
                for (int i = 0; i < ids.length; ++i) {
                    AffineTransform xform;
                    String id = ids[i];
                    AbstractElement element = (AbstractElement)document.getElementById(id);
                    if (element == null) {
                        return null;
                    }
                    try {
                        xform = MatrixTools.toJavaTransform(((SVGLocatable)element).getScreenCTM().inverse());
                    }
                    catch (SVGException se) {
                        continue;
                    }
                    xform.deltaTransform(screenDelta, delta);
                    AffineTransform trans = AffineTransform.getTranslateInstance(((Point2D)delta).getX(), ((Point2D)delta).getY());
                    String xformS = element.getAttributeNS(null, "transform");
                    xform = xformS == null ? new AffineTransform() : MatrixTools.toJavaTransform(xformS);
                    xform.concatenate(trans);
                    element.setAttributeNS(null, "transform", MatrixTools.toSVGString(xform));
                    DocumentManager.this.recursiveTransform(element);
                }
                return null;
            }
        });
    }

    public void scaleIDs(final String[] ids, final Point2D screenDelta, final Point2D screenPos) {
        if (ids == null || ids.length == 0) {
            return;
        }
        this.modifyDocumentLater(new DocumentModifier(){

            public Object run(DocumentManager documentManager) {
                SVGDocument document = documentManager.getSVGDocument();
                for (int i = 0; i < ids.length; ++i) {
                    String id = ids[i];
                    AbstractElement element = (AbstractElement)document.getElementById(id);
                    if (element == null) {
                        return null;
                    }
                    SVGLocatable locatable = (SVGLocatable)element;
                    AffineTransform CTM = MatrixTools.toJavaTransform(locatable.getScreenCTM());
                    SVGRect bbox = locatable.getBBox();
                    Point2D.Double center = new Point2D.Double((double)bbox.getX() + 0.5 * (double)bbox.getWidth(), (double)bbox.getY() + 0.5 * (double)bbox.getHeight());
                    Point2D.Double centerOnScreen = new Point2D.Double();
                    CTM.transform(center, centerOnScreen);
                    double distanceOrg = centerOnScreen.distance(screenPos);
                    screenPos.setLocation(screenPos.getX() + screenDelta.getX(), screenPos.getY() + screenDelta.getY());
                    double distanceDelta = centerOnScreen.distance(screenPos);
                    double scale = distanceDelta / distanceOrg;
                    AffineTransform trans1 = AffineTransform.getTranslateInstance(-((Point2D)center).getX(), -((Point2D)center).getY());
                    AffineTransform scaleTrans = AffineTransform.getScaleInstance(scale, scale);
                    AffineTransform trans2 = AffineTransform.getTranslateInstance(((Point2D)center).getX(), ((Point2D)center).getY());
                    scaleTrans.concatenate(trans1);
                    trans2.concatenate(scaleTrans);
                    String xformS = element.getAttributeNS(null, "transform");
                    AffineTransform xform = xformS == null ? new AffineTransform() : MatrixTools.toJavaTransform(xformS);
                    xform.concatenate(trans2);
                    element.setAttributeNS(null, "transform", MatrixTools.toSVGString(xform));
                    DocumentManager.this.recursiveTransform(element);
                }
                return null;
            }
        });
    }

    public void rotateIDs(final String[] ids, final Point2D screenDelta, final Point2D screenPos) {
        if (ids == null || ids.length == 0) {
            return;
        }
        this.modifyDocumentLater(new DocumentModifier(){

            public Object run(DocumentManager documentManager) {
                SVGDocument document = documentManager.getSVGDocument();
                for (int i = 0; i < ids.length; ++i) {
                    AffineTransform invCTM;
                    String id = ids[i];
                    AbstractElement element = (AbstractElement)document.getElementById(id);
                    if (element == null) {
                        return null;
                    }
                    SVGLocatable locatable = (SVGLocatable)element;
                    AffineTransform CTM = MatrixTools.toJavaTransform(locatable.getScreenCTM());
                    try {
                        invCTM = CTM.createInverse();
                    }
                    catch (NoninvertibleTransformException nite) {
                        continue;
                    }
                    SVGRect bbox = locatable.getBBox();
                    Point2D.Double center = new Point2D.Double((double)bbox.getX() + 0.5 * (double)bbox.getWidth(), (double)bbox.getY() + 0.5 * (double)bbox.getHeight());
                    Point2D.Double screenPosInCTM = new Point2D.Double();
                    invCTM.transform(screenPos, screenPosInCTM);
                    Point2D.Double deltaInCTM = new Point2D.Double();
                    invCTM.deltaTransform(screenDelta, deltaInCTM);
                    double alpha = GeometricMath.angleBetween(center, screenPosInCTM);
                    ((Point2D)screenPosInCTM).setLocation(((Point2D)screenPosInCTM).getX() + ((Point2D)deltaInCTM).getX(), ((Point2D)screenPosInCTM).getY() + ((Point2D)deltaInCTM).getY());
                    double beta = GeometricMath.angleBetween(center, screenPosInCTM);
                    double gamma = beta - alpha;
                    AffineTransform rotate = AffineTransform.getRotateInstance(gamma, ((Point2D)center).getX(), ((Point2D)center).getY());
                    String xformS = element.getAttributeNS(null, "transform");
                    AffineTransform xform = xformS == null ? new AffineTransform() : MatrixTools.toJavaTransform(xformS);
                    xform.concatenate(rotate);
                    element.setAttributeNS(null, "transform", MatrixTools.toSVGString(xform));
                    DocumentManager.this.recursiveTransform(element);
                }
                return null;
            }
        });
    }

    public void generateRulers() {
        this.modifyDocumentLater(new DocumentModifier(){

            public Object run(DocumentManager documentManager) {
                double length;
                double[] sizes = new double[2];
                documentManager.getPaperSize(sizes);
                SVGDocument document = documentManager.getSVGDocument();
                AbstractElement root = (AbstractElement)document.getElementById(DocumentManager.DOCUMENT_BELOW);
                root.appendChild((Node)this.line(document, 17.0, 20.0, 17.0, sizes[1] + 20.0));
                root.appendChild((Node)this.line(document, 20.0, 17.0, sizes[0] + 20.0, 17.0));
                int count = 0;
                for (double x = 0.0; x <= sizes[0]; x += 1.0) {
                    length = count == 0 ? 7.0 : (count == 5 ? 3.5 : 2.0);
                    if (++count > 9) {
                        count = 0;
                    }
                    root.appendChild((Node)this.line(document, 20.0 + x, 17.0, 20.0 + x, 17.0 - length));
                }
                count = 0;
                for (double y = 0.0; y <= sizes[1]; y += 1.0) {
                    length = count == 0 ? 7.0 : (count == 5 ? 3.5 : 2.0);
                    if (++count > 9) {
                        count = 0;
                    }
                    root.appendChild((Node)this.line(document, 17.0, 20.0 + y, 17.0 - length, 20.0 + y));
                }
                return null;
            }

            private AbstractElement line(SVGDocument doc, double x1, double y1, double x2, double y2) {
                String svgNS = "http://www.w3.org/2000/svg";
                AbstractElement l = (AbstractElement)doc.createElementNS(svgNS, "line");
                l.setAttributeNS(null, "x1", String.valueOf(x1));
                l.setAttributeNS(null, "y1", String.valueOf(y1));
                l.setAttributeNS(null, "x2", String.valueOf(x2));
                l.setAttributeNS(null, "y2", String.valueOf(y2));
                l.setAttributeNS(null, "stroke", "black");
                l.setAttributeNS(null, "stroke-width", "0.5");
                return l;
            }
        });
    }

    protected static interface ElementVisitor {
        public boolean visit(AbstractElement var1);
    }

    public static interface ModificationCallback {
        public void run(DocumentManager var1, AbstractElement var2);
    }

    public static interface DocumentModifier {
        public Object run(DocumentManager var1);
    }
}

