#! /usr/bin/python
# Copyright (C) 2000, 2001 Intevation GmbH <intevation@intevation.de>
# Author: Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the LGPL (>=v2)
# Read the file COPYING coming with MapIt! for details.

"""A very simple HTTP server for mapit.

NOTE: This server is only intended as a demonstration of MapIt! and may
be insecure! Do not use this server as a publically available
web-server.

Usage:

python mapitserver.py [-c command] [port]

port is the port the server listens on; default is 31415. Point your
webbrowser to http://localhost:port/

command is a command executed after starting the server. This can be
used to automatically start a webbrowser pointing to the mapitserver.

"""

__version__ = "$Revision: 1.4 $"

import os
import sys
import time
import socket
import string
import urllib
import BaseHTTPServer
import SimpleHTTPServer
import posixpath
try:
    import cStringIO
    StringIO = cStringIO
except ImportError:
    import StringIO

import cgi

if __name__ == '__main__':
    # assuming we're run directly in the mapit source tree, sys.path[0]
    # should be the directory where mapitserver.py is located, so use
    # that to add ../base to the path
    sys.path.insert(0, os.path.join(sys.path[0], '..', 'base'))

import showmap, genmap


class MapitHTTPRequestHandler(SimpleHTTPServer.SimpleHTTPRequestHandler):

    mapit_handlers = {'/showmap':showmap, '/genmap':genmap}
    pathmap = [('/simple/Icons', '../../examples/herne/icons/')]
    errorfile = '../../examples/europe/icons/non-existing-file'

    def do_POST(self):
        """Serve a POST request.

        This is only implemented for CGI scripts.

        """

        if self.is_cgi():
            self.run_cgi()
        else:
            self.send_error(501, "Can only POST to CGI scripts")

    def send_head(self):
        """Version of send_head that support CGI scripts"""
        if self.is_cgi():
            return self.run_cgi()
        else:
            return SimpleHTTPServer.SimpleHTTPRequestHandler.send_head(self)

    def is_cgi(self):
        """Return true if self.path refers to a CGI script. In mapit
        this means either showmap or genmap. '/', '/index.html' and
        '/index.htm' are treated as '/showmap'
        """
        
        path = self.path
        if path in ('/', '/index.html', '/index.htm'):
            path = '/showmap'
        for x in self.mapit_handlers.keys():
            i = len(x)
            if path[:i] == x and (not path[i:] or path[i] == '?'):
                self.cgi_info = path[:i], path[i+1:]
                return 1
        return 0

    def run_cgi(self):
        """Execute a mapit request"""
        script, query = self.cgi_info
        module = self.mapit_handlers[script]

        try:
            # Reference: http://hoohoo.ncsa.uiuc.edu/cgi/env.html
            # XXX Much of the following could be prepared ahead of time!
            env = {}
            env['SERVER_SOFTWARE'] = self.version_string()
            env['SERVER_NAME'] = self.server.server_name
            env['GATEWAY_INTERFACE'] = 'CGI/1.1'
            env['SERVER_PROTOCOL'] = self.protocol_version
            env['SERVER_PORT'] = str(self.server.server_port)
            env['REQUEST_METHOD'] = self.command
            #uqrest = urllib.unquote(rest)
            #env['PATH_INFO'] = uqrest
            #env['PATH_TRANSLATED'] = self.translate_path(uqrest)
            env['SCRIPT_NAME'] = script
            if query:
                env['QUERY_STRING'] = query
            host = self.address_string()
            if host != self.client_address[0]:
                env['REMOTE_HOST'] = host
            env['REMOTE_ADDR'] = self.client_address[0]
            # AUTH_TYPE
            # REMOTE_USER
            # REMOTE_IDENT
            if self.headers.typeheader is None:
                env['CONTENT_TYPE'] = self.headers.type
            else:
                env['CONTENT_TYPE'] = self.headers.typeheader
            length = self.headers.getheader('content-length')
            if length:
                env['CONTENT_LENGTH'] = length
            accept = []
            for line in self.headers.getallmatchingheaders('accept'):
                if line[:1] in string.whitespace:
                    accept.append(string.strip(line))
                else:
                    accept = accept + string.split(line[7:], ',')
            env['HTTP_ACCEPT'] = string.joinfields(accept, ',')
            ua = self.headers.getheader('user-agent')
            if ua:
                env['HTTP_USER_AGENT'] = ua

            self.send_response(200, "Script output follows")

            # On UNIX (well, only tested on Linux :) ), we could pass
            # self.wfile directly to module.handle_cgi. However, that
            # doesn't work on NT (I got some error messages in PIL about
            # a 'bad file descriptor'). So we use the roundabout way of
            # writing into a StringIO-buffer first.
            tempfile = StringIO.StringIO()
            module.handle_cgi(cgi.FieldStorage(fp = self.rfile, environ = env),
                              tempfile)
            self.wfile.write(tempfile.getvalue())
        except:
            self.server.handle_error(self.request, self.client_address)

    def translate_path(self, path):
        """Return the filename that self.path refers to. self.pathmap is
        used to translate prefixes.
        """
        path = posixpath.normpath(path)
        head, tail = posixpath.split(path)
        for old, new in self.pathmap:
            i = len(old)
            if head == old:
                path = posixpath.join(new, tail)
                return path
        return self.errorfile

def run_server(HandlerClass = MapitHTTPRequestHandler,
               ServerClass = BaseHTTPServer.HTTPServer):
    command = ''
    argv = sys.argv[1:]
    if argv and argv[0] == '-c':
        if len(argv) >= 2:
            command = argv[1]
            argv = argv[2:]
        else:
            argv = []
    if argv:
        port = string.atoi(argv[0])
    else:
        port = 31415
    server_address = ('', port)


    httpd = ServerClass(server_address, HandlerClass)
    print "Serving HTTP on port", port, "..."

    if command:
        os.system(command)
    httpd.serve_forever()


if __name__ == '__main__':
    run_server()
