# Copyright (C) 2000 Intevation GmbH <intevation@intevation.de>
# Author: Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the LGPL (>=v2)
# Read the file COPYING coming with MapIt! for details.

import os, sys

import pagetemplate, tileinfo, markerinfo, common, mapconfig

template = pagetemplate.TemplateProcessor(mapconfig.template_file)
map = tileinfo.MapInfo(mapconfig.tile_dir, mapconfig.tile_ext)
marker = markerinfo.MarkerInfo(mapconfig.marker_locations,
                               mapconfig.marker_dir,
                               mapconfig.marker_ext)
markers_tested = 0


def test_markers(out):
    global markers_tested
    if not markers_tested:
        result = marker.check_marker_images()
        if result:
            out.write(result)
            out.write('\n')
    else:
        markers_tested = 0

def handle_cgi(fields, stdout, showmap = "showmap", genmap = "genmap"):
    stdout.write('Content-type: text/html\n\n')
    test_markers(stdout)
    parameters = common.Parameters(fields, map = map,
                                   marker = marker, showmap = showmap,
                                   genmap = genmap)
    template.generate_html(parameters, stdout)
