# Copyright (C) 2000 Intevation GmbH <intevation@intevation.de>
# Author: Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the LGPL (>=v2)
# Read the file COPYING coming with MapIt! for details.

import os, sys

import makemap, tileinfo, markerinfo, common, mapconfig

map = tileinfo.MapInfo(mapconfig.tile_dir, mapconfig.tile_ext)
marker = markerinfo.MarkerInfo(mapconfig.marker_locations,
                               mapconfig.marker_dir,
                               mapconfig.marker_ext)


def print_map(image, fd, format, **params):
    """Print image to stdout as an image file

    Parameters:
        image - PIL image
        format - The PIL name of the output format
        **params - Additional keyword parameters that are passed through
                   to the image's save method
    """
    apply(image.save, (fd, format), params)

def handle_cgi(fields, stdout):
    parameters = common.Parameters(fields, map = map, marker = marker)
    stdout.write('Content-type: ' + mapconfig.output_mime + '\n\n')
    image = makemap.generate_map(parameters)
    print_map(image, stdout, mapconfig.output_pil_format)
    makemap.write_log_entry(mapconfig.makemap_counter_file)
