# Copyright (C) 2000 Intevation GmbH <intevation@intevation.de>
# Author: Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the LGPL (>=v2)
# Read the file COPYING coming with MapIt! for details.

#
#      Configuration
#

#
# Options for the generated map image
#


#
# The Tile Data
#


# _base_dir is only used within this file
# this path points to the directory containing the data
# (tiles, markers, etc.)
_base_dir = '../../examples/europe/'

# The default scale to use
scale = 3

# The default location to use. None means the center of the map
default_x = None
default_y = None

# data_dir is the name of the directory where the map tiles can be
# found.
tile_dir = _base_dir + '/tiles'

# The file extension of the tile files
tile_ext = '.png'


#
# Output format and size
#

# The MIME type of the format
output_mime = 'image/jpg'

# The PIL name of the format. This is passed to a PIL Image's save
# method. Obviously the values of output_pil_format and output_mime have
# to match
output_pil_format = 'JPEG'

# The values needed for PNG output
#output_mime = 'image/png'
#output_pil_format = 'PNG'

# Default image size in pixels
image_width = 400
image_height = 400

# Maximum image size.
max_image_width = 800
max_image_height = 800

# Minimum image size
min_image_width = 50
min_image_height = 50

# counter file
makemap_counter_file = ''


# Amount to scroll when clicking on the navigation icons measured in
# pixels. The values should be less or equal to the image size.
scroll_horizontal = 380
scroll_vertical = 380

# Overlap in pixels of neightboring maps generated when scrolling
# through the map with the arrow icons.
scroll_overlap = 20

# Navigation grid parameters
navigation_grid_width = 30
navigation_grid_height = 30

#
# Marker symbols
#

# The file that describes the markers. Its format is described in
# marker.py
#marker_locations = _base_dir + '/markerdefs.de'
marker_locations = _base_dir + '/markerdefs.en'

# The directory where the marker icons can be found
marker_dir = _base_dir + '/markers'


# The file extension of the marker icons
marker_ext = ".png"

#
# Stamp
# The stamp is a small image placed in the lower left corner of every map.
#

stamp_location = _base_dir + "/stamp.png"

#
#       Template
#
#template_file = _base_dir + "/simple.de.template"
template_file = _base_dir + "/simple.en.template"

template_item_start = r"\<\s*mapit:(?P<element>[a-zA-Z_0-9]+)"
template_item_end = r"\s*\>"
