# Copyright (C) 2000 Intevation GmbH <intevation@intevation.de>
# Author: Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the LGPL (>=v2)
# Read the file COPYING coming with MapIt! for details.

import sys, os, cgi
from string import split
from mod_python import apache

sys.path.insert(0, os.path.join(os.path.split(__file__)[0], '../base'))

mapit_scripts = {'showmap': 'showmap',
                 'genmap': 'genmap'}

def cgi_env(req):
    env = apache.build_cgi_env(req)
    stdout = apache.CGIStdout(req)
    stdin = apache.CGIStdin(req)
    return env, stdin, stdout

def handler(req):
    scriptname = split(req.uri, "/")[-1]
    modulename = mapit_scripts.get(scriptname)
    if modulename:
        module = __import__(modulename)
        env, stdin, stdout = cgi_env(req)
        module.handle_cgi(cgi.FieldStorage(fp = stdin, environ = env),
                          stdout)
        return apache.OK
    return apache.HTTP_NOT_FOUND
