#! /usr/bin/python -O
# Copyright (C) 2000 Intevation GmbH <intevation@intevation.de>
# Author: Bernhard Herzog <bh@intevation.de>

import os, sys

import fcgi
sys.path.insert(0, os.path.join(sys.path[0], '../base'))
import pagetemplate, tileinfo, markerinfo, common, mapconfig

def main():
    template = pagetemplate.TemplateProcessor(mapconfig.template_file)
    map = tileinfo.MapInfo(mapconfig.tile_dir, mapconfig.tile_ext)
    marker = markerinfo.MarkerInfo(mapconfig.marker_locations,
                                   mapconfig.marker_dir,
                                   mapconfig.marker_ext)
    test_markers = 1
    while fcgi.isFCGI():
        req = fcgi.FCGI()
        print 'Content-type: text/html'
        print
        if test_markers:
            result = marker.check_marker_images()
            if result:
                print result
            else:
                test_markers = 0
        parameters = common.Parameters(req.getFieldStorage(), map = map,
                                       marker = marker, showmap="showmap.cgi",
                                       genmap="genmap.cgi")
        template.generate_html(parameters, sys.stdout)

	req.Finish()

main()
