#! /usr/bin/python -O
# Copyright (C) 2000 Intevation GmbH <intevation@intevation.de>
# Author: Bernhard Herzog <bh@intevation.de>

import time
start_time = time.clock()

import os, sys
import fcgi
sys.path.insert(0, os.path.join(sys.path[0], '../base'))

import makemap, tileinfo, markerinfo, common, mapconfig

def print_map(image, fd, format, **params):
    """Print image to stdout as an image file

    Parameters:
        image - PIL image
        format - The PIL name of the output format
        **params - Additional keyword parameters that are passed through
                   to the image's save method
    """
    apply(image.save, (fd, format), params)

def main():
    map = tileinfo.MapInfo(mapconfig.tile_dir, mapconfig.tile_ext)
    marker = markerinfo.MarkerInfo(mapconfig.marker_locations,
                                   mapconfig.marker_dir,
                                   mapconfig.marker_ext)
    while fcgi.isFCGI():
        req = fcgi.FCGI()
        parameters = common.Parameters(req.getFieldStorage(),
                                       map = map, marker = marker)
        print 'Content-type: ' + mapconfig.output_mime
        print
        image = makemap.generate_map(parameters)
        print_map(image, req.out, mapconfig.output_pil_format)
        makemap.write_log_entry(mapconfig.makemap_counter_file)

	req.Finish()


main()
