# Copyright (C) 2003 by Intevation GmbH
# Authors:
# Thomas Koester <tkoester@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

"""
Unit test for notebook.py
"""

__version__ = "$Revision: 1.6 $"
# $Source: /greaterrepository/sciparam/test/test_notebook.py,v $
# $Id: test_notebook.py,v 1.6 2003/07/21 13:54:05 tkoester Exp $

import unittest

import support
support.init()

from wxPython.wx import *

from SciParam.UI import ParameterNotebookDialog
from SciParam.UI.test_parameter_list import parameter, parameter1

class ParameterNotebookDialogTest(support.wxTestCase):

    def test_column_number(self):
        """check number of columns"""
        for cols in [1, 2]:
            notebook = ParameterNotebookDialog(NULL, -1, 'ParameterNotebook',
                                               parameter, columns=cols)
            notebook.Show(true)
            for page in notebook.parameter:
                self.assertEqual(len(page[1]), cols,
                                 'Number of columns is %d (should be %d)' %
                                 (len(page[1]), cols))
            notebook.Close()
            notebook.Destroy()

    def test_illegal_column(self):
        """check illegal values for column"""
        for cols in [-1, 0, 3, 1.5, '2', [1]]:
            self.assertRaises(ValueError, ParameterNotebookDialog, NULL, -1,
                              'ParameterNB', parameter, columns=cols)
            pass

    def test_illegal_parameter(self):
        """check illegal values for parameter"""
        for par in [None, [], parameter1[0], [parameter1], ["string"],
                    parameter1 + [("string", 1)], [(1, [parameter1])]]:
            self.assertRaises(TypeError, ParameterNotebookDialog, NULL, -1,
                              'ParameterNB', par)


if __name__ == "__main__":
    unittest.main()
