# Copyright (C) 2003 by Intevation GmbH
# Authors:
# Thomas Koester <tkoester@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

"""
Unit test for dialog.py
"""

__version__ = "$Revision: 1.8 $"
# $Source: /greaterrepository/sciparam/test/test_dialog.py,v $
# $Id: test_dialog.py,v 1.8 2003/07/21 13:54:05 tkoester Exp $

import unittest

import support
support.init()

from wxPython.wx import *

from SciParam import StringParam
from SciParam.UI import ParameterDialog
from SciParam.UI.test_parameter_list import parameter1, parameter2, parameter3

class ParameterDialogTest(support.wxTestCase):

    def test_column_number(self):
        """check number of columns"""
        for parameter in [parameter1, parameter2, parameter3]:
            for cols in [1, 2]:
                dialog = ParameterDialog(NULL, -1, 'ParameterDialog',
                                         parameter, columns=cols)
                dialog.Show(true)
                self.assertEqual(len(dialog.parameter), cols,
                                 'Number of columns is %d (should be %d)' %
                                 (len(dialog.parameter), cols))
                dialog.Close()
                dialog.Destroy()

    def test_illegal_column(self):
        """check illegal values for column"""
        for cols in [-1, 0, 3, 1.5, '2', [1]]:
            self.assertRaises(ValueError, ParameterDialog, NULL, -1,
                              'ParameterDialog', parameter1, columns=cols)

    def test_illegal_parameter(self):
        """check illegal values for parameter"""
        for par in [None, [], parameter1[0], [parameter1], ["string"],
                    parameter1 + [("string", 1)], [(1, [parameter1])]]:
            self.assertRaises(TypeError, ParameterDialog, NULL, -1,
                              'ParameterDialog', par)

    def test_first_control(self):
        """check status of first control"""
        parameter = [
            StringParam('StringParam', value='something')
        ]
        dialog = ParameterDialog(NULL, -1, 'ParameterDialog', parameter)
        dialog.Show(true)
        dialog.pargrid.details.connect(dialog.pargrid.controls[0])
        wxYield()
        parctrl = dialog.pargrid.details.parctrl
        self.assertEqual(parctrl.GetValue(), parameter[0].value)
        dialog.Close()
        dialog.Destroy()


if __name__ == "__main__":
    unittest.main()
