# Copyright (C) 2003 by Intevation GmbH
# Authors:
# Thomas Koester <tkoester@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

"""
Unit test for detailsbox.py
"""

__version__ = "$Revision: 1.13 $"
# $Source: /greaterrepository/sciparam/test/test_detailsbox.py,v $
# $Id: test_detailsbox.py,v 1.13 2003/07/21 13:54:05 tkoester Exp $

import unittest

import support
support.init()

from wxPython.wx import *

from SciParam import DistParam
from SciParam.UI import ParameterDialog
from SciParam.UI.detailsbox import ParameterDistributionDialog

class ParameterDistributionDialogTest(support.wxTestCase):

    def wxappSetUp(self):
        """create test application"""
        parameter = [
            DistParam('DistParam', value='1;2/uniform'),
        ]
        self.dialog = ParameterDialog(NULL, -1, 'ParameterDialog', parameter)
        self.dialog.Show(true)
        self.dialog.pargrid.connect(self.dialog.pargrid.controls[0])

    def tearDown(self):
        """destroy test application window"""
        self.dialog.Close()
        self.dialog.Destroy()

    def test_distdialog(self):
        """check ParameterDistributionDialog"""
        parctrl = self.dialog.pargrid.controls[0]
        self.dialog.pargrid.connect(parctrl)
        dist = parctrl.parameter.value
        for dist_type in dist.types:
            parctrl.dist_type = dist_type
            distdialog = ParameterDistributionDialog(self.dialog, parctrl)
            distdialog.Show(true)
            self.assertCenteredOnParent(distdialog)
            for i in range(dist.descriptives_len(dist_type)):
                self.assertEqual(distdialog.desc_params[dist_type][i].name,
                                 dist.descriptives_map[dist_type][i])
            self.assert_(distdialog.Validate())
            self.assert_(distdialog.TransferDataFromWindow())
            distdialog.Close()
            distdialog.Destroy()


if __name__ == "__main__":
    unittest.main()
