# Copyright (C) 2002, 2003 by Intevation GmbH
# Authors:
# Thomas Koester <tkoester@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

"""
Unit test support
"""

__version__ = "$Revision: 1.7 $"
# $Source: /greaterrepository/sciparam/test/support.py,v $
# $Id: support.py,v 1.7 2003/07/21 13:54:05 tkoester Exp $

import os, sys
import unittest

from wxPython.wx import *

def add_package_dir_to_path(dir):
    """Insert the package directory at the beginning of the python path.

    If it's already part of the path, remove later occurrences.
    """
    dir = os.path.join(os.path.dirname(__file__), dir)
    while 1:
        try:
            sys.path.remove(dir)
        except ValueError:
            break
    sys.path.insert(0, dir)

_init_done = 0
def init():
    """Initialize the interpreter"""
    global _init_done
    if not _init_done:
        add_package_dir_to_path(os.pardir)
        _init_done = 1


class FloatTestCase(unittest.TestCase):
    """TestCase with methods for testing floating point values"""

    fp_epsilon = 1e-6
    fp_inf = float('1e1000')   # FIXME: hack for infinite

    def assertFloatEqual(self, first, second, msg=None):
        """Fail if one float is greater than the other + fp_epsilon"""
        if abs(first) == self.fp_inf:
            self.assertEqual(first, second, msg)
        else:
            self.assert_(self.fp_epsilon > abs(first - second), msg)


wxapp = None

class wxTestCase(unittest.TestCase):
    """TestCase with methods for testing wxPython apps"""

    def setUp(self):
        """create test application"""
        global wxapp
        if not wxapp:
            wxapp = wxPySimpleApp()
        if hasattr(self, 'wxappSetUp'):
            self.wxappSetUp()

    def GetWindowCenter(self, window):
        """Return a wxSize object containing the center of a window"""
        pos_x, pos_y = window.GetPositionTuple()
        width, height = window.GetClientSizeTuple()
        return wxSize(pos_x + width/2, pos_y + height/2)

    def assertCenteredOnParent(self, window, msg=None):
        """Fail if a window isn't centered on its parent"""
        parentcenter = self.GetWindowCenter(window.GetParent())
        windowcenter = self.GetWindowCenter(window)

        self.assert_(abs(parentcenter.x - windowcenter.x) < 2, msg)
        self.assert_(abs(parentcenter.y - windowcenter.y) < 2, msg)

