# Copyright (c) 2002, 2003 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
# Thomas Koester <tkoester@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

"""
Main entry point for the unit test suite.

Just run this file as a python script to execute all tests
"""

__version__ = "$Revision: 1.5 $"
# $Source: /greaterrepository/sciparam/test/runtests.py,v $
# $Id: runtests.py,v 1.5 2003/07/21 13:54:05 tkoester Exp $

import os, os.path, sys
import unittest

import support
support.init()


def main():
    """Run all the tests in the test suite"""

    files = os.listdir(os.path.dirname(__file__))
    names = []
    for file in files:
        if file[:4] == "test" and file[-3:] == ".py":
            names.append(file[:-3])

    suite = unittest.defaultTestLoader.loadTestsFromNames(names)
    runner = unittest.TextTestRunner(verbosity = 2)
    result = runner.run(suite)

    sys.exit(not result.wasSuccessful())


if __name__ == "__main__":
    __file__ = os.path.join(os.getcwd(), sys.argv[0])
    main()
