# Copyright (c) 2002, 2003 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

__version__ = "$Revision: 1.12 $"
# $Source: /greaterrepository/sciparam/setup.py,v $
# $Id: setup.py,v 1.12 2003/07/16 15:36:35 tkoester Exp $

from distutils.core import setup
from distutils.command.install_data import install_data

from SciParam.version import version

class sciparam_install_data(install_data):

    def finalize_options(self):
        self.set_undefined_options('install',
                                   ('install_purelib', 'install_dir'))
        install_data.finalize_options(self)


setup(name = "SciParam",
      version = version,
      description = "Scientific Parameters",
      long_description = """\
SciParam is a package to easily add additional quality control for
entering scientific parameters in wxPython-based user interfaces.
""",
      licence = "GPL",
      author = "Intevation GmbH",
      author_email = "tkoester@intevation.de",
      url = "http://great-er.intevation.de/sciparam/",

      packages = ["SciParam", "SciParam.UI"],
      data_files = [("SciParam/UI", ["SciParam/UI/required.xpm"])],

      cmdclass = {"install_data": sciparam_install_data}
)
