# Copyright (C) 2002 by Intevation GmbH
# Authors:
# Thomas Koester <tkoester@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

"""
Scientific Parameter version information
"""

__version__ = "$Revision: 1.10 $"
# $Source: /greaterrepository/sciparam/SciParam/version.py,v $
# $Id: version.py,v 1.10 2003/07/21 14:02:17 tkoester Exp $


version = '1.0.0'
append_date = 0
#version = '1.0.1cvs'
#append_date = 1


import os, os.path
import time

if __name__ == "__main__":
    import sys
    __file__ = sys.argv[0]

def is_relevant_file(file):
    """check if a file is relevant for determining the current version"""
    extensions = ['.py', '.xpm', '.c', '.h']
    return os.path.isfile(file) and os.path.splitext(file)[1] in extensions

def visit(args, dirname, names):
    """helper for os.path.walk; save mtime of newest file for this directory"""
    files = filter(is_relevant_file,
                   [os.path.join(dirname, file) for file in names])
    args['max'] = max([args['max']] + map(os.path.getmtime, files))

def get_date(format):
    """strftime formatted mtime of the newest relevant file"""
    dir = os.path.dirname(os.path.abspath(__file__))
    args = {'max': 0}
    os.path.walk(dir, visit, args)
    return time.strftime(format, time.localtime(args['max']))


if append_date:
    version = '%s-%s' % (version, get_date('%Y%m%d'))
longversion = 'SciParam %s' % version

if __name__ == "__main__":
    print longversion
