# Copyright (C) 2002, 2003 by Intevation GmbH
# Authors:
# Thomas Koester <tkoester@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

"""
List of parameters for GUI tests
"""

__version__ = "$Revision: 1.3 $"
# $Source: /greaterrepository/sciparam/SciParam/UI/test_parameter_list.py,v $
# $Id: test_parameter_list.py,v 1.3 2003/07/21 13:54:05 tkoester Exp $

from SciParam import FloatParam, IntParam, StringParam, ChoiceParam, DistParam

parameter1 = [
    StringParam('Name', 'a unique identifier', required=1,
                value='Silicon', maxlength=20,
                comment='This is an example for a required value.\n'
                        'The user can change this comment to note the '
                        'source of this information.'),
    StringParam('Symbol', 'chemical symbol', required=1, value='Si'),
    IntParam('Atomic No',
             'Number in the periodic table of the elements',
             value=14, wrange='[1;260]', erange='[1;oo['),
    FloatParam('Atomic Mass', None, value=28.0855, erange='[0;oo['),
    #StringParam('COLUMN_BREAK'),
    FloatParam('Melting Point', 'under normal conditions', 'C',
               value=1414,
               wrange='[-273.15;4e3]', erange='[-273.15;oo['),
    FloatParam('Boiling Point', 'under normal conditions', 'C',
               value=3265, wrange='[-270;6e3]', erange='[-273.15;oo['),
    ChoiceParam('Crystal', 'crystal structure',
                choices=[None, 'simple cubic', 'face centered cubic',
                         'body centered cubic', 'diamond cubic',
                         'tetragonal', 'orthorombic', 'monoclinc'],
                value='face centered cubic',
                default='face centered cubic', long=1),
    DistParam('Temperature', 'temperature of samples', 'C',
              default=20, value='17.5;3.7/normal', erange='[-273.15;oo['),
    DistParam('Volume', 'Volume of used samples', 'cm',
              default='2;20/uniform', erange='[0;oo['),
    ChoiceParam('Verified', 'Have these values been checked?',
                choices=ChoiceParam.yes_no, value=0, default=1),
]

parameter2 = [
    ChoiceParam('LongChoiceParameter', 'a long list of choices',
                choices=[None, 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h',
                         'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q',
                         'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
                         'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
                         'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q',
                         'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'],
                default='x', long=1,
                comment='This parameter may not be unknown.', notunknown=1),
    StringParam('Name', 'a unique identifier with a very long description '
                        'that may not fit in the details box',
                comment='This parameter may not be unknown.', notunknown=1),
    StringParam('Description', default='This is a very long default that'
                                       'may not fit in the details box'),
    IntParam('Things', 'Number of things', 'pcs',
             erange='[0;oo['),
    FloatParam('Price', 'per thing', '', value=0.49, default=1.20,
               wrange='[0.50;1e5[', erange='[0;oo[',
               comment='This is too cheap'),
    ChoiceParam('Size', 'Select one of 3m, 5m, 7m', 'm',
                default=5, choices=[3, 5, 7]),
    ChoiceParam('In Stock', 'Are there enough things?',
                comment='This parameter may not be unknown.', notunknown=1),
    DistParam('narrow limits', erange='[0;2['),
]

parameter3 = []
param_count = [1,5,1,1,1,3,4,1,2,5]
single_parameter = 1
group_nr = 1
for i in range(len(param_count)):
    if param_count[i] == 1:
        parameter3.append(StringParam('single Param%d' % single_parameter))
        single_parameter += 1
    else:
        params = []
        for j in range(1, param_count[i]+1):
            params.append(StringParam('Group%d Param%d' % (group_nr, j)))
        parameter3.append((group_nr != 3 and 'Group %d' % group_nr or '',
                           params))
        group_nr += 1


parameter = [('Element', parameter1),
             ('Things', parameter2),
             ('Groups', parameter3),
             ('long titled dummy page 1', [StringParam('dummy')]),
             ('long titled dummy page 2', [StringParam('dummy')]),
             ('long titled dummy page 3', [StringParam('dummy')]),
             ('long titled dummy page 4', [StringParam('dummy')]),
             ('long titled dummy page 5', [StringParam('dummy')]),
             ('long titled dummy page 6', [StringParam('dummy')]),
]
