# Copyright (C) 2002, 2003 by Intevation GmbH
# Authors:
# Thomas Koester <tkoester@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

"""
Grid of Scientific Parameter Controls for wxPython
"""

__version__ = "$Revision: 1.4 $"
# $Source: /greaterrepository/sciparam/SciParam/UI/pargrid.py,v $
# $Id: pargrid.py,v 1.4 2003/07/21 13:54:05 tkoester Exp $

import os.path
import types

from wxPython.wx import *

from SciParam import SciParam, ChoiceParam

from control import ParameterCtrl, ParameterChoice, ParameterLongChoice
from control import _SPACE, _SMALLSPACE

class ParameterColumn(wxBoxSizer):

    requiredIcon = None

    def __init__(self, parent):
        wxBoxSizer.__init__(self, wxVERTICAL)
        self.parent = parent
        if not ParameterColumn.requiredIcon:
            required_xpm = os.path.join(os.path.dirname(__file__),
                                        'required.xpm')
            ParameterColumn.requiredIcon = wxBitmap(required_xpm,
                                                    wxBITMAP_TYPE_XPM)

    def AddGroup(self, name=None):
        if name is None:
            box = wxBoxSizer(wxHORIZONTAL)
        else:
            staticbox = wxStaticBox(self.parent, -1, name)
            box = wxStaticBoxSizer(staticbox, wxHORIZONTAL)
        wxBoxSizer.Add(self, box, 0, wxGROW | wxBOTTOM, _SPACE)
        self.label = wxGridSizer(0, 1, vgap=_SPACE)
        self.icon = wxGridSizer(0, 1, vgap=_SPACE)
        self.entry = wxGridSizer(0, 1, vgap=_SPACE)
        box.Add(self.label, 0, wxRIGHT | wxGROW, _SMALLSPACE)
        box.Add(self.icon, 0, wxRIGHT | wxGROW, _SMALLSPACE)
        box.Add(self.entry, 0, wxGROW)

    def Add(self, control):
        label = wxStaticText(self.parent, -1, '')
        self.label.Add(label, 0, wxALIGN_CENTER_VERTICAL | wxALIGN_RIGHT)
        icon = wxStaticBitmap(self.parent, -1, self.requiredIcon)
        icon.SetToolTip(wxToolTip('required'))
        self.icon.Add(icon, 0, wxALIGN_CENTER_VERTICAL | wxALIGN_RIGHT)

        entry = wxBoxSizer(wxHORIZONTAL)
        entry.Add(control, 0, wxALIGN_CENTER_VERTICAL)
        unit = wxStaticText(self.parent, -1, '')
        entry.Add(unit, 0, wxALIGN_CENTER_VERTICAL | wxLEFT, _SMALLSPACE)
        self.entry.Add(entry, 0, wxALIGN_CENTER_VERTICAL)
        control.label = label
        control.icon = icon
        control.unit = unit
        control.UpdateFromParameter()


class ParameterGrid(wxGridSizer):

    def __init__(self, parent, details, parameter):
        wxGridSizer.__init__(self, 1, 0, hgap=2*_SPACE)
        self.parent = parent
        self.details = details
        self.parctrl = None

        self.controls = []

        for col in parameter:
            column = ParameterColumn(parent)
            self.Add(column, 1)
            inside_group = false
            for par in col:
                if isinstance(par, SciParam):
                    if not inside_group:
                        column.AddGroup()
                        inside_group = true
                    self.AddParameter(par, column)
                elif type(par) == types.TupleType and len(par) == 2:
                    column.AddGroup(par[0])
                    for grouppar in par[1]:
                        self.AddParameter(grouppar, column)
                    inside_group = false
                else:
                    raise TypeError, "%s used with wrong object: %s" % \
                                     (self.__class__, repr(par))

    def AddParameter(self, parameter, column):
        if isinstance(parameter, ChoiceParam):
            if parameter.long:
                parameterCtrl = ParameterLongChoice(self.parent, -1,
                                                    parameter, self)
            else:
                parameterCtrl = ParameterChoice(self.parent, -1,
                                                parameter, self)
        else:
            parameterCtrl = ParameterCtrl(self.parent, -1,
                                          parameter, self)
        self.controls.append(parameterCtrl)
        column.Add(parameterCtrl)

    def refocus(self, pos=None):
        if pos is None:
            if self.parctrl:
                self.parctrl.refocus = true
            elif self.controls:
                self.controls[0].refocus = true
        elif pos < len(self.controls):
            self.controls[pos].refocus = true

    def connect(self, parctrl=None):
        if parctrl is self.parctrl:
            return
        if parctrl:
            self.parctrl = parctrl
        if self.details:
            self.details.connect(parctrl)

    def connect_distribution(self, parctrl):
        if self.details:
            self.details.connect_distribution(parctrl)

    def ValidateComment(self, ctrl):
        return not self.details or self.details.ValidateComment(ctrl)

    def CtrlOnKeyDown(self, event):
        """Catch details key from parameter controls"""
        if self.details:
            self.details.CtrlOnKeyDown(event)
        else:
            event.Skip()

