#!/usr/bin/env python
#
# Copyright (C) 2002 by Intevation GmbH
# Authors:
# Thomas Koester <tkoester@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

"""
Scientific Parameters
"""

from SciParam import FloatParam, IntParam, StringParam, ChoiceParam, DistParam

if __name__ == "__main__":
    parameter = [
        StringParam('Name', 'a unique identifier', required=1,
                    value='Silicon',
                    comment='This is an example for a required value.\n'
                            'The user can change this comment to note the '
                            'source of this information.'),
        StringParam('Symbol', 'chemical symbol', required=1, value='Si'),
        IntParam('Atomic No',
                 'Number in the periodic table of the elements',
                 value=14, wrange='[1;260]', erange='[1;oo['),
        FloatParam('Atomic Mass', None, value=28.0855, erange='[0;oo['),
        FloatParam('Melting Point', 'under normal conditions', 'C',
                   value=1414,
                   wrange='[-273.15;4e3]', erange='[-273.15;oo['),
        FloatParam('Boiling Point', 'under normal conditions', 'C',
                   value=3265, wrange='[-270;6e3]', erange='[-273.15;oo['),
        ChoiceParam('Crystal', 'crystal structure',
                    choices=[None, 'simple cubic', 'face centered cubic',
                             'body centered cubic', 'diamond cubic',
                             'tetragonal', 'orthorombic', 'monoclinc'],
                    value='face centered cubic', long=1),
        DistParam('Temperature', 'temperature of samples', 'C',
                  default=20, value=17.5, erange='[-273.15;oo[',
                  dist=(3.7, 'normal')),
        DistParam('Volume', 'Volume of used samples', 'cm',
                  default='2;20/uniform', erange='[0;oo['),
        ChoiceParam('Verified', 'Have these values been checked?',
                    choices=ChoiceParam.yes_no, value=0),
    ]

    for par in parameter:
        print par.name, "=", par.value
        print " comment =", par.comment
        if isinstance(par, DistParam):
            print " dist =", par.dist


