# Copyright (c) 2002 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

__version__ = "$Revision: 1.5 $"
# $Source: /greaterrepository/sciparam/setup.py,v $
# $Id: setup.py,v 1.5 2002/07/30 17:28:55 tkoester Exp $

from distutils.core import setup
from distutils.command.install_data import install_data

class sciparam_install_data(install_data):

    def finalize_options(self):
        self.set_undefined_options('install',
                                   ('install_purelib', 'install_dir'))
        install_data.finalize_options(self)


setup(name = "SciParam",
      version = "0.9.0",
      description = "Scientific Parameters",
      long_description = """\
SciParam is a package to easily add additional quality control for
entering scientific parameters in wxPython-based user interfaces.
""",
      licence = "GPL",
      author = "Intevation GmbH",
      author_email = "tkoester@intevation.de",
      url = "http://great-er.intevation.de/sciparam.html",

      packages = ["SciParam"],
      data_files = [("SciParam", ["SciParam/required.xpm"])],

      cmdclass = {"install_data": sciparam_install_data}
)
