#!/usr/bin/env python
#
# Copyright (C) 2002 by Intevation GmbH
# Authors:
# Thomas Koester <tkoester@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

"""
Distribution class for Scientific Parameter
"""

__version__ = "$Revision: 1.5 $"
# $Source: /greaterrepository/sciparam/SciParam/distribution.py,v $
# $Id: distribution.py,v 1.5 2002/07/23 14:15:31 tkoester Exp $

import types

class Distribution:
    types = ['none', 'normal', 'log-normal', 'uniform']
    none = types[0]
    parameter = {
        'none': ('value', 'not used'),
        'normal': ('mean value', 'std. deviation'),
        'log-normal': ('mean value', 'std. deviation'),
        'uniform': ('min. value', 'max. value'),
    }
    def __init__(self, value=None, type=None):
        if isinstance(value, Distribution):
            self.type = value.type
            self.value = value.value
        else:
            self.type = None
            self.value = value
            if type is not None:
                self.type = type

    def __str__(self):
        return "%s/%s" % (self.value, self.type)

    def __setattr__(self, name, value):
        if name == 'value':
            if type(value) == types.TupleType and len(value) == 2:
                self.value, self.type = value
            elif type(value) == types.StringType:
                parts = value.split('/')
                if len(parts) == 2:
                    value, self.type = parts
                elif len(parts) != 1:
                    raise ValueError, "not a distribution: %s" % (value,)
                self.__dict__[name] = float(value)
            else:
                try:
                    value = float(str(value))
                except ValueError, why:
                    value = None
                self.__dict__[name] = value
        elif name == 'type':
            if value is None:
                value = self.none
            else:
                value = value.strip().lower()
                if value not in self.types:
                    raise ValueError, "not a distribution type: %s" % (value,)
            self.__dict__[name] = value
        else:
            raise AttributeError, "%s has no attribute '%s'" % \
                                  (self.__class__, name)


def _test():
    dist0 = Distribution()
    print "dist0: %s (value: %s, type: %s)" % (dist0, dist0.value, dist0.type)

    dist1 = Distribution("10/uniform")
    print "dist1: %s (value: %s, type: %s)" % (dist1, dist1.value, dist1.type)
    print "set dist1.value to 11.5"
    dist1.value = 11.5
    print "dist1: %s (value: %s, type: %s)" % (dist1, dist1.value, dist1.type)
    print "set dist1.type to 'normal'"
    dist1.type = 'normal'
    print "dist1: %s (value: %s, type: %s)" % (dist1, dist1.value, dist1.type)
    print "set dist1.value to '-5'"
    dist1.value = '-5'
    print "dist1: %s (value: %s, type: %s)" % (dist1, dist1.value, dist1.type)
    print "set dist1.value to '-10.7/log-normal'"
    dist1.value = '-10.7/log-normal'
    print "dist1: %s (value: %s, type: %s)" % (dist1, dist1.value, dist1.type)
    print "set dist1.value to (7e-5, 'uniform')"
    dist1.value = (7e-5, 'uniform')
    print "dist1: %s (value: %s, type: %s)" % (dist1, dist1.value, dist1.type)


if __name__ == "__main__":
    _test()
