#!/usr/local/bin/wish
#############################################################################
# Visual Tcl v1.10 Project
#

#################################
# GLOBAL VARIABLES
#
global PCP_Comment_label; 
global S_CAS; 
global S_H; 
global S_H_cmt; 
global S_K_AW; 
global S_K_AW_cmt; 
global S_K_DO; 
global S_K_DO_cmt; 
global S_K_OW; 
global S_K_OW_cmt; 
global S_Kd_river; 
global S_Kd_river_cmt; 
global S_Kd_sewage; 
global S_Kd_sewage_cmt; 
global S_Kd_sludge; 
global S_Kd_sludge_cmt; 
global S_MW; 
global S_MW_cmt; 
global S_Q10; 
global S_Q10_cmt; 
global S_alpha_anaerobic; 
global S_alpha_aerobic_cmt; 
global S_alpha_sorbed; 
global S_alpha_sorbed_cmt; 
global S_bp; 
global S_bp_cmt; 
global S_bp_temp; 
global S_bp_un; 
global S_comment; 
global S_def_consumption; 
global S_def_consumption_cmt; 
global S_k_aerobic; 
global S_k_aerobic_cmt; 
global S_k_hydr_a; 
global S_k_hydr_a_cmt; 
global S_k_hydr_b; 
global S_k_hydr_b_cmt; 
global S_k_hydr_n; 
global S_k_hydr_n_cmt; 
global S_k_photo; 
global S_k_photo_cmt; 
global S_mp; 
global S_mp_cmt; 
global S_mp_temp; 
global S_mp_un; 
global S_name; 
global S_pKa; 
global S_pKa_cmt; 
global S_protolysis; 
global S_protolysis_cmt; 
global S_vp; 
global S_vp_cmt; 
global S_ws; 
global abs_null; 
global curr_focus; 
global curr_raised_button; 
global curr_raised_frame; 
global filename; 
global op_title; 
global widget; 

#################################
# USER DEFINED PROCEDURES
#
proc init {argc argv} {
global curr_raised_frame curr_raised_button curr_comment curr_focus
global filename op_title
global S_CAS S_name S_comment
global S_MW S_mp S_bp S_pKa S_protolysis S_K_OW S_ws S_vp S_H
global S_MW_cmt S_mp_cmt S_bp_cmt S_pKa_cmt S_protolysis_cmt S_K_OW_cmt S_ws_cm S_vp_cmt S_H_cmt
global S_mp_temp S_mp_un S_bp_temp S_bp_un
global S_def_consumption
global S_def_consumption_cmt
global S_K_DO S_Q10 S_k_aerobic S_alpha_anaerobic S_alpha_sorbed
global S_K_DO_cmt S_Q10_cmt S_k_aerobic_cmt S_alpha_aerobic_cmt S_alpha_sorbed_cmt
global S_k_hydr_a S_k_hydr_n S_k_hydr_b
global S_k_hydr_a_cmt S_k_hydr_n_cmt S_k_hydr_b_cmt
global S_k_photo
global S_k_photo_cmt
global S_K_AW S_Kd_river S_Kd_sludge S_Kd_sewage
global S_K_AW_cmt S_Kd_river_cmt S_Kd_sludge_cmt S_Kd_sewage_cmt
global abs_null

if {$argv == ""} {
        set filename ""
        set op_title "Test Mode"

        set S_name "Test Substance"
        set S_CAS "4711"
        set S_comment "no filename - test data inserted"

        set S_def_consumption "unknown"

        set S_MW "unknown"
        set S_bp "unknown"
        set S_mp "unknown"
        set S_pKa "unknown"
        set S_protolysis "unknown"
        set S_K_a "unknown"
        set S_K_b "unknown"
        set S_K_OW "unknown"
        set S_ws "unknown"
        set S_vp "unknown"
        set S_H "unknown"

        set S_K_DO "unknown"
        set S_Q10 "unknown"
        set S_k_aerobic "unknown"
        set S_alpha_anaerobic "unknown"
        set S_alpha_sorbed "unknown"

        set S_k_hydr_n  "unknown"
        set S_k_hydr_b  "unknown"
        set S_k_hydr_a  "unknown"
        set S_k_photo  "unknown"

        set S_K_AW "unknown"
        set S_Kd_river "unknown"
        set S_Kd_sludge "unknown"
        set S_Kd_sewage "unknown"

} else {
        set filename $argv

        set datafile [ open $filename r ]

        gets $datafile op_title
        gets $datafile S_name
        gets $datafile S_CAS
        gets $datafile S_comment

        gets $datafile S_def_consumption

        gets $datafile S_MW
        gets $datafile S_bp
        gets $datafile S_mp
        gets $datafile S_pKa
        gets $datafile S_protolysis
        gets $datafile S_K_a
        gets $datafile S_K_b
        gets $datafile S_K_OW
        gets $datafile S_ws
        gets $datafile S_vp
        gets $datafile S_H

        gets $datafile S_K_DO
        gets $datafile S_Q10
        gets $datafile S_k_aerobic
        gets $datafile S_alpha_anaerobic
        gets $datafile S_alpha_sorbed

        gets $datafile S_k_hydr_n
        gets $datafile S_k_hydr_b
        gets $datafile S_k_hydr_a
        gets $datafile S_k_photo

        gets $datafile S_K_AW
        gets $datafile S_Kd_river
        gets $datafile S_Kd_sludge
        gets $datafile S_Kd_sewage

        close $datafile

        # empty the transfer file
        set datafile [ open $filename w ]
        close $datafile

 }

	set curr_raised_button ".top17.06"
	set curr_raised_frame ".top17.fra35"
	set curr_commment ""
	set abs_null "273.15"
	set curr_focus ""
	set S_MW_cmt ""
	set S_mp_cmt ""
	set S_mp_temp $S_mp
	set S_mp_un "\[K\]"
	set S_bp_cmt ""
	set S_bp_temp $S_bp
	set S_bp_un "\[K\]"
	set S_pKa_cmt ""
	set S_protolysis_cmt ""
	set S_K_OW_cmt ""
	set S_ws_cmt ""
	set S_vp_cmt ""
	set S_H_cmt ""
	set S_def_consumption_cmt ""
	set S_K_DO_cmt ""
	set S_Q10_cmt ""
	set S_k_aerobic_cmt ""
	set S_alpha_aerobic_cmt ""
	set S_alpha_sorbed_cmt ""
	set S_k_hydr_a_cmt ""
	set S_k_hydr_n_cmt ""
	set S_k_hydr_b_cmt ""
	set S_k_photo_cmt ""
	set S_K_AW_cmt ""
	set S_Kd_river_cmt ""
	set S_Kd_sludge_cmt ""
	set S_Kd_sewage_cmt ""
}

init $argc $argv


proc ch_raised_frame {new_raised_frame new_raised_button new_focus} {
global curr_raised_frame curr_raised_button curr_focus

	set curr_focus ""

	lower $curr_raised_frame
	$curr_raised_button config -relief groove

	raise $new_raised_frame
	$new_raised_button config -relief raised

        focus $new_focus

	set curr_raised_button $new_raised_button
	set curr_raised_frame $new_raised_frame
}

proc do_focus {} {
global curr_focus
	if {$curr_focus != ""} {
		focus $curr_focus
		set curr_focus ""
		}
}

proc get_comment {} {
global curr_comment
	return [$curr_comment get 1.0 end]
}

proc isNumber num {
        return [regexp {^((\-)?[0-9]+)(([.][0-9]+)?)$} $num]
	}

proc saveData {} {
global filename op_title S_name S_CAS S_comment
global S_def_consumption
global S_MW S_K_OW S_ws S_vp S_bp S_mp S_K_d S_K_AW S_pKa S_K_a S_K_b S_H
global S_protolysis S_k_aerobic S_alpha_anaerobic S_K_DO S_alpha_sorbed
global S_Q10 S_k_hydr_n S_k_hydr_b S_k_hydr_a S_k_photo
global S_Kd_river S_Kd_sludge S_Kd_sewage 

if { $filename != "" } {
        set datafile [ open $filename w ]

# calculate K_a and K_b by pKa
	set pKa_isNumber [ catch { expr $S_pKa * 1 } ]
	if { $pKa_isNumber } {
		set S_K_a "unknown"
		set S_K_b "unknown"
	} else {
        	set S_K_a [ expr pow(10, [expr $S_pKa * -1 ] ) ]
        	set S_K_b [ expr pow(10, [expr -1 * [ expr 14 - $S_pKa ]] ) ]
	}

        puts $datafile $S_name
        puts $datafile $S_CAS
        puts $datafile $S_comment

        puts $datafile $S_def_consumption

        puts $datafile $S_MW
        puts $datafile $S_bp
        puts $datafile $S_mp
        puts $datafile $S_pKa
        puts $datafile $S_protolysis
        puts $datafile $S_K_a
        puts $datafile $S_K_b
        puts $datafile $S_K_OW
        puts $datafile $S_ws
        puts $datafile $S_vp
        puts $datafile $S_H

        puts $datafile $S_K_DO
        puts $datafile $S_Q10
        puts $datafile $S_k_aerobic
        puts $datafile $S_alpha_anaerobic
        puts $datafile $S_alpha_sorbed

        puts $datafile $S_k_hydr_n
        puts $datafile $S_k_hydr_b
        puts $datafile $S_k_hydr_a
        puts $datafile $S_k_photo

        puts $datafile $S_K_AW
        puts $datafile $S_Kd_river
        puts $datafile $S_Kd_sludge
        puts $datafile $S_Kd_sewage

        close $datafile
}
}

proc update_comment {text} {
global curr_comment
	$curr_comment delete 1.0 end
	$curr_comment insert end $text
}

proc main {argc argv} {

}

proc Window {args} {
global vTcl
    set cmd [lindex $args 0]
    set name [lindex $args 1]
    set newname [lindex $args 2]
    set rest [lrange $args 3 end]
    if {$name == "" || $cmd == ""} {return}
    if {$newname == ""} {
        set newname $name
    }
    set exists [winfo exists $newname]
    switch $cmd {
        show {
            if {$exists == "1" && $name != "."} {wm deiconify $name; return}
            if {[info procs vTclWindow(pre)$name] != ""} {
                eval "vTclWindow(pre)$name $newname $rest"
            }
            if {[info procs vTclWindow$name] != ""} {
                eval "vTclWindow$name $newname $rest"
            }
            if {[info procs vTclWindow(post)$name] != ""} {
                eval "vTclWindow(post)$name $newname $rest"
            }
        }
        hide    { if $exists {wm withdraw $newname; return} }
        iconify { if $exists {wm iconify $newname; return} }
        destroy { if $exists {destroy $newname; return} }
    }
}

#################################
# VTCL GENERATED GUI PROCEDURES
#

proc vTclWindow. {base} {
    if {$base == ""} {
        set base .
    }
    ###################
    # CREATING WIDGETS
    ###################
    wm focusmodel $base passive
    wm geometry $base 200x200+0+0
    wm maxsize $base 1156 867
    wm minsize $base 104 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm withdraw $base
    wm title $base "C:Programmet-1.08t.tcl"
    ###################
    # SETTING GEOMETRY
    ###################
}

proc vTclWindow.top17 {base} {
    if {$base == ""} {
        set base .top17
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 755x473+210+338
    wm maxsize $base 1156 867
    wm minsize $base 104 1
    wm overrideredirect $base 0
    wm resizable $base 0 0
    wm deiconify $base
    wm title $base "Substance Editor"
    frame $base.fra34 \
        -borderwidth 1 -height 75 -relief raised -width 125 
    bind $base.fra34 <FocusIn> {
        set curr_comment .top17.fra34.fra46.tex22
    }
    frame $base.fra34.fra46 \
        -borderwidth 1 -height 75 -relief sunken -width 125 
    label $base.fra34.fra46.lab47 \
        -anchor w -borderwidth 1 \
        -text {Molar mass:} 
    label $base.fra34.fra46.lab48 \
        -anchor w -borderwidth 1 \
        -text {Melting point:} 
    label $base.fra34.fra46.lab49 \
        -anchor w -borderwidth 1 \
        -text {Boiling point:} 
    label $base.fra34.fra46.lab50 \
        -anchor w -borderwidth 1 \
        -text pKa: 
    label $base.fra34.fra46.lab51 \
        -anchor w -borderwidth 1 \
        -text Protolysis: 
    label $base.fra34.fra46.lab52 \
        -anchor w -borderwidth 1 \
        -text Kow: 
    label $base.fra34.fra46.lab53 \
        -anchor w -borderwidth 1 \
        -text {Water solubility:} 
    label $base.fra34.fra46.lab54 \
        -anchor w -borderwidth 1 \
        -text {Vapor pressure:} 
    label $base.fra34.fra46.lab55 \
        -anchor w -borderwidth 1 \
        -text {Henry coefficient:} 
    entry $base.fra34.fra46.ent56 \
        -textvariable S_MW 
    bind $base.fra34.fra46.ent56 <FocusIn> {
        if {$curr_focus != ""} {
		focus $curr_focus
		set curr_focus ""
	} else {
        	set PCP_Comment_label "Molar mass"
		update_comment $S_MW_cmt
		}
    }
    bind $base.fra34.fra46.ent56 <FocusOut> {
        set S_MW_cmt [get_comment]
    }
    bind $base.fra34.fra46.ent56 <Shift-Key-Tab> {
        set curr_focus .top17.fra34.fra46.ent67
    }
    entry $base.fra34.fra46.ent57 \
        -textvariable S_mp_temp 
    bind $base.fra34.fra46.ent57 <FocusIn> {
        set PCP_Comment_label "Melting point"
	update_comment $S_mp_cmt
    }
    bind $base.fra34.fra46.ent57 <FocusOut> {
        if {[isNumber $S_mp_temp] == "1" && $S_mp_un == "\[oC\]"} {
		set S_mp [expr $S_mp_temp + $abs_null]
	} else {
		set S_mp $S_mp_temp
    		}
    set S_mp_cmt [join [get_comment] " "]
    }
    entry $base.fra34.fra46.ent58 \
        -textvariable S_bp_temp 
    bind $base.fra34.fra46.ent58 <FocusIn> {
        set PCP_Comment_label "Boiling point"
    }
    bind $base.fra34.fra46.ent58 <FocusOut> {
        if {[isNumber $S_bp_temp] == "1" && $S_bp_un == "\[oC\]"} {
    		set S_bp [expr $S_bp_temp + $abs_null]
	} else {
    		set S_bp $S_bp_temp
    		}
    }
    entry $base.fra34.fra46.ent59 \
        -textvariable S_pKa 
    bind $base.fra34.fra46.ent59 <FocusIn> {
        set PCP_Comment_label "pKa"
    }
    radiobutton $base.fra34.fra46.rad60 \
        -text acidic \
        -value -1 -variable S_protolysis 
    bind $base.fra34.fra46.rad60 <FocusIn> {
        set PCP_Comment_label "Protolysis"
    }
    radiobutton $base.fra34.fra46.rad62 \
        -text neutral \
        -value 0 -variable S_protolysis 
    bind $base.fra34.fra46.rad62 <FocusIn> {
        set PCP_Comment_label "Protolysis"
    }
    radiobutton $base.fra34.fra46.rad63 \
        -text alkaline \
        -value 1 -variable S_protolysis 
    bind $base.fra34.fra46.rad63 <FocusIn> {
        set PCP_Comment_label "Protolysis"
    }
    entry $base.fra34.fra46.ent64 \
        -textvariable S_K_OW 
    bind $base.fra34.fra46.ent64 <FocusIn> {
        set PCP_Comment_label "Kow"
    }
    entry $base.fra34.fra46.ent65 \
        -textvariable S_ws 
    bind $base.fra34.fra46.ent65 <FocusIn> {
        set PCP_Comment_label "Water solubility"
    }
    entry $base.fra34.fra46.ent66 \
        -textvariable S_vp 
    bind $base.fra34.fra46.ent66 <FocusIn> {
        set PCP_Comment_label "Vapor pressure"
    }
    entry $base.fra34.fra46.ent67 \
        -textvariable S_H 
    bind $base.fra34.fra46.ent67 <FocusIn> {
        set PCP_Comment_label "Henry coefficient"
    }
    bind $base.fra34.fra46.ent67 <Key-Tab> {
        set curr_focus .top17.fra34.fra46.ent56
    }
    text $base.fra34.fra46.tex22
    bind $base.fra34.fra46.tex22 <FocusIn> {
        do_focus
    }
    label $base.fra34.fra46.lab17 \
        -borderwidth 1 \
        -text Kow -textvariable PCP_Comment_label 
    label $base.fra34.fra46.lab18 \
        -anchor w -borderwidth 1 \
        -text {[ - ]} 
    label $base.fra34.fra46.lab20 \
        -anchor w -borderwidth 1 \
        -text {[ - ]} 
    label $base.fra34.fra46.lab21 \
        -anchor w -borderwidth 1 \
        -text {[g/L]} 
    label $base.fra34.fra46.lab22 \
        -anchor w -borderwidth 1 \
        -text {[Pa]} 
    label $base.fra34.fra46.lab23 \
        -anchor w -borderwidth 1 \
        -text {[Pa m^3/mol]} 
    label $base.fra34.fra46.lab26 \
        -anchor w -borderwidth 1 \
        -text {[g/mol]} 
    menubutton $base.fra34.fra46.men18 \
        -anchor w -borderwidth 1 \
        -indicatoron 1 \
        -menu .top17.fra34.fra46.men18.m -padx 5 -pady 4 -relief raised \
        -text {[K]} -textvariable S_mp_un 
    menu $base.fra34.fra46.men18.m \
        -borderwidth 1 \
        -tearoff 0 
    $base.fra34.fra46.men18.m add command \
        -command {set S_mp_un \[oC\]
        if {[isNumber $S_mp_temp] == "1"} {
	set S_mp_temp [expr $S_mp - $abs_null]}} \
        -label {[oC]} 
    $base.fra34.fra46.men18.m add command \
        -command {set S_mp_un \[K\]
	set S_mp_temp $S_mp} -label {[K]} 
    menubutton $base.fra34.fra46.men19 \
        -anchor w -borderwidth 1 \
        -indicatoron 1 \
        -menu .top17.fra34.fra46.men19.01 -padx 5 -pady 4 -relief raised \
        -text {[K]} -textvariable S_bp_un 
    menu $base.fra34.fra46.men19.01 \
        -borderwidth 1 \
        -tearoff 0 
    $base.fra34.fra46.men19.01 add command \
        -command {set S_bp_un \[oC\]
        if {[isNumber $S_bp_temp] == "1"} {
		set S_bp_temp [expr $S_bp - $abs_null]} }\
        -label {[oC]} 
    $base.fra34.fra46.men19.01 add command \
        -command {set S_bp_un \[K\]
set S_bp_temp $S_bp} -label {[K]} 

    frame $base.fra68 \
        -borderwidth 1 -height 75 -relief raised -width 125 
    frame $base.fra68.fra107 \
        -borderwidth 1 -height 75 -relief sunken -width 125 
    label $base.fra68.fra107.02 \
        -anchor w -borderwidth 1 \
        -text Kaw: 
    entry $base.fra68.fra107.03 \
        -textvariable S_K_AW 
    bind $base.fra68.fra107.03 <FocusIn> {
        do_focus
    }
    bind $base.fra68.fra107.03 <Shift-Key-Tab> {
        set curr_focus .top17.fra68.fra107.ent110
    }
    entry $base.fra68.fra107.ent108 \
        -textvariable S_Kd_river 
    entry $base.fra68.fra107.ent109 \
        -textvariable S_Kd_sludge 
    entry $base.fra68.fra107.ent110 \
        -textvariable S_Kd_sewage 
    bind $base.fra68.fra107.ent110 <FocusIn> {
        do_focus
    }
    bind $base.fra68.fra107.ent110 <Key-Tab> {
        set curr_focus .top17.fra68.fra107.03
    }
    label $base.fra68.fra107.lab111 \
        -anchor w -borderwidth 1 \
        -text {Kd river:} 
    label $base.fra68.fra107.lab112 \
        -anchor w -borderwidth 1 \
        -text {Kd sludge:} 
    label $base.fra68.fra107.lab113 \
        -anchor w -borderwidth 1 \
        -text {Kd sewage:} 
    label $base.fra68.fra107.lab37 \
        -anchor w -borderwidth 1 \
        -text {[ - ]} 
    label $base.fra68.fra107.lab38 \
        -anchor w -borderwidth 1 \
        -text {[L/kg]} 
    label $base.fra68.fra107.lab39 \
        -anchor w -borderwidth 1 \
        -text {[L/kg]} 
    label $base.fra68.fra107.lab40 \
        -anchor w -borderwidth 1 \
        -text {[L/kg]} 
    frame $base.011 \
        -borderwidth 1 -height 75 -relief raised -width 125 
    frame $base.011.fra80 \
        -borderwidth 1 -height 75 -relief sunken -width 125 
    label $base.011.fra80.lab85 \
        -anchor w -borderwidth 1 \
        -text Biodegradation 
    label $base.011.fra80.lab86 \
        -anchor w -borderwidth 1 \
        -text {K DO:} 
    label $base.011.fra80.lab87 \
        -anchor w -borderwidth 1 \
        -text Q10: 
    label $base.011.fra80.lab88 \
        -anchor w -borderwidth 1 \
        -text {k aerobic:} 
    label $base.011.fra80.lab89 \
        -anchor w -borderwidth 1 \
        -text {alpha anaerobic:} 
    label $base.011.fra80.lab90 \
        -anchor w -borderwidth 1 \
        -text {alpha sorbed:} 
    entry $base.011.fra80.ent91 \
        -textvariable S_K_DO 
    bind $base.011.fra80.ent91 <FocusIn> {
        do_focus
    }
    bind $base.011.fra80.ent91 <Shift-Key-Tab> {
        set curr_focus .top17.011.fra84.ent106
    }
    entry $base.011.fra80.ent92 \
        -textvariable S_Q10 
    entry $base.011.fra80.ent93 \
        -textvariable S_k_aerobic 
    entry $base.011.fra80.ent94 \
        -textvariable S_alpha_anaerobic 
    entry $base.011.fra80.ent95 \
        -textvariable S_alpha_sorbed 
    label $base.011.fra80.lab28 \
        -anchor w -borderwidth 1 \
        -text {[mg/L]} 
    label $base.011.fra80.lab29 \
        -anchor w -borderwidth 1 \
        -text {[ - ]} 
    label $base.011.fra80.lab30 \
        -anchor w -borderwidth 1 \
        -text {[1/h]} 
    label $base.011.fra80.lab31 \
        -anchor w -borderwidth 1 \
        -text {[ - ]} 
    label $base.011.fra80.lab32 \
        -anchor w -borderwidth 1 \
        -text {[ - ]} 
    frame $base.011.fra83 \
        -borderwidth 1 -height 75 -relief sunken -width 125 
    label $base.011.fra83.lab97 \
        -anchor w -borderwidth 1 \
        -text {k acidic:} 
    label $base.011.fra83.lab98 \
        -anchor w -borderwidth 1 \
        -text {k neutral:} 
    label $base.011.fra83.lab99 \
        -anchor w -borderwidth 1 \
        -text {k alkaline:} 
    label $base.011.fra83.lab100 \
        -anchor w -borderwidth 1 \
        -text Hydrolysis 
    entry $base.011.fra83.ent101 \
        -textvariable S_k_hydr_a 
    entry $base.011.fra83.ent102 \
        -textvariable S_k_hydr_n 
    entry $base.011.fra83.ent103 \
        -textvariable S_k_hydr_b 
    label $base.011.fra83.lab33 \
        -anchor w -borderwidth 1 \
        -text {[1/h]} 
    label $base.011.fra83.lab34 \
        -anchor w -borderwidth 1 \
        -text {[1/h]} 
    label $base.011.fra83.lab35 \
        -anchor w -borderwidth 1 \
        -text {[1/h]} 
    frame $base.011.fra84 \
        -borderwidth 1 -height 75 -relief sunken -width 125 
    label $base.011.fra84.lab104 \
        -anchor w -borderwidth 1 \
        -text Photolysis 
    label $base.011.fra84.lab105 \
        -anchor w -borderwidth 1 \
        -text {k photo:} 
    entry $base.011.fra84.ent106 \
        -textvariable S_k_photo 
    bind $base.011.fra84.ent106 <FocusIn> {
        do_focus
    }
    bind $base.011.fra84.ent106 <Key-Tab> {
        set curr_focus .top17.011.fra80.ent91
    }
    label $base.011.fra84.lab36 \
        -anchor w -borderwidth 1 \
        -text {[1/h]} 
    frame $base.fra33 \
        -borderwidth 1 -height 75 -relief raised -width 125 
    frame $base.fra33.fra77 \
        -borderwidth 1 -height 75 -relief sunken -width 125 
    label $base.fra33.fra77.lab78 \
        -anchor w -borderwidth 1 \
        -text {Default Consumption:} 
    entry $base.fra33.fra77.ent79 \
        -textvariable S_def_consumption 
    bind $base.fra33.fra77.ent79 <FocusIn> {
        do_focus
    }
    bind $base.fra33.fra77.ent79 <Key-Tab> {
        set curr_focus .top17.fra33.fra77.ent79
    }
    bind $base.fra33.fra77.ent79 <Shift-Key-Tab> {
        set curr_focus .top17.fra33.fra77.ent79
    }
    label $base.fra33.fra77.lab27 \
        -anchor w -borderwidth 1 \
        -text {[kg/(cap a)]} 
    button $base.01 \
        -command {saveData;
destroy .} \
        -padx 10 -pady 3 \
        -text OK 
    bind $base.01 <FocusIn> {
        do_focus
    }
    bind $base.01 <Shift-Key-Tab> {
        set curr_focus .top17.01
    }
    button $base.02 \
        -command {destroy .} \
        -padx 10 -pady 3 \
        -text Cancel 
    button $base.but96 \
        -command {tk_messageBox -title "Substance Editor - Help" \
		-message {A help system for this dialog is not yet supported. 
In a future release it will be possible to browse \
			help files in HTML format.}} \
        -padx 10 -pady 3 \
        -text Help 
    button $base.03 \
        -command {tk_messageBox -title "Substance Editor - Estimate Info" \
		-message {This functionality is not yet supported.
It will make it possible to automatically estimate\
			the values of certain model parameters.}} \
        -padx 10 -pady 3 \
        -text Estimate 
    button $base.05 \
        -command {tk_messageBox -title "Substance Editor - Distribution Info" \
		-message {This functionality is not yet supported.
It will make it possible to select one of the\
			distribution types, provided by the stochastic model,\
			for the current parameter.
Depending on the selected type further dialog boxes\
			will raise to ask for needed parameters.}} \
        -padx 10 -pady 3 \
        -text Distribution 
    button $base.06 \
        \
        -command {ch_raised_frame .top17.fra35 .top17.06 .top17.fra35.fra39.ent43} \
        -padx 10 -pady 3 \
        -text Identification 
    button $base.07 \
        \
        -command {ch_raised_frame .top17.fra34 .top17.07 .top17.fra34.fra46.ent56} \
        -padx 10 -pady 3 \
        -relief groove -text {Physico-Chemical Properties} 
    button $base.08 \
        \
        -command {ch_raised_frame .top17.fra33 .top17.08 .top17.fra33.fra77.ent79} \
        -padx 10 -pady 3 \
        -relief groove -text {Market Information} 
    button $base.09 \
        \
        -command {ch_raised_frame .top17.011 .top17.09 .top17.011.fra80.ent91} \
        -padx 10 -pady 3 \
        -relief groove -text Degradation 
    button $base.010 \
        \
        -command {ch_raised_frame .top17.fra68 .top17.010 .top17.fra68.fra107.03} \
        -padx 10 -pady 3 \
        -relief groove -text Partitioning 

    frame $base.fra35 \
        -borderwidth 1 -height 75 -relief raised -width 125 
    frame $base.fra35.fra39 \
        -borderwidth 1 -height 75 -relief sunken -width 125 
    label $base.fra35.fra39.lab40 \
        -anchor w -borderwidth 1 \
        -text Name: 
    label $base.fra35.fra39.lab41 \
        -anchor w -borderwidth 1 \
        -text CAS-No: 
    label $base.fra35.fra39.lab42 \
        -anchor w -borderwidth 1 \
        -text Comment: 
    entry $base.fra35.fra39.ent43 \
        -textvariable S_name 
    bind $base.fra35.fra39.ent43 <FocusIn> {
        do_focus
    }
    bind $base.fra35.fra39.ent43 <Shift-Key-Tab> {
        set curr_focus .top17.fra35.fra39.tex28
    }
    entry $base.fra35.fra39.ent44 \
        -textvariable S_CAS 
    text $base.fra35.fra39.tex28
    bind $base.fra35.fra39.tex28 <FocusIn> {
        do_focus
    }
    bind $base.fra35.fra39.tex28 <Key-Tab> {
        set curr_focus .top17.fra35.fra39.ent43
    }
    bind all <Escape> {
	destroy .
	}
    bind all <Return> {
	saveData
	destroy .
	}   
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.fra34 \
        -x 10 -y 35 -width 735 -height 385 -anchor nw -bordermode ignore 
    place $base.fra34.fra46 \
        -x 10 -y 10 -width 715 -height 235 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab47 \
        -x 5 -y 5 -width 91 -height 24 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab48 \
        -x 5 -y 30 -width 91 -height 24 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab49 \
        -x 5 -y 55 -width 91 -height 24 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab50 \
        -x 5 -y 80 -width 91 -height 24 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab51 \
        -x 5 -y 105 -width 91 -height 24 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab52 \
        -x 5 -y 130 -width 91 -height 24 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab53 \
        -x 5 -y 155 -width 106 -height 24 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab54 \
        -x 5 -y 180 -width 111 -height 24 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab55 \
        -x 5 -y 205 -width 121 -height 24 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.ent56 \
        -x 135 -y 5 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.ent57 \
        -x 135 -y 30 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.ent58 \
        -x 135 -y 55 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.ent59 \
        -x 135 -y 80 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.rad60 \
        -x 135 -y 105 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.rad62 \
        -x 200 -y 105 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.rad63 \
        -x 272 -y 105 -width 75 -height 24 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.ent64 \
        -x 135 -y 130 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.ent65 \
        -x 135 -y 155 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.ent66 \
        -x 135 -y 180 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.ent67 \
        -x 135 -y 205 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.tex22 \
        -x 500 -y 40 -width 205 -height 107 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab17 \
        -x 500 -y 5 -width 206 -height 28 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab18 \
        -x 285 -y 80 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab20 \
        -x 285 -y 130 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab21 \
        -x 285 -y 155 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab22 \
        -x 285 -y 180 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab23 \
        -x 285 -y 205 -width 76 -height 23 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.lab26 \
        -x 285 -y 5 -width 51 -height 23 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.men18 \
        -x 285 -y 30 -width 56 -height 25 -anchor nw -bordermode ignore 
    place $base.fra34.fra46.men19 \
        -x 285 -y 55 -width 56 -height 25 -anchor nw -bordermode ignore 
    place $base.fra68 \
        -x 10 -y 35 -width 735 -height 385 -anchor nw -bordermode ignore 
    place $base.fra68.fra107 \
        -x 10 -y 10 -width 715 -height 120 -anchor nw -bordermode ignore 
    place $base.fra68.fra107.02 \
        -x 10 -y 10 -width 56 -height 24 -anchor nw -bordermode ignore 
    place $base.fra68.fra107.03 \
        -x 100 -y 10 -anchor nw -bordermode ignore 
    place $base.fra68.fra107.ent108 \
        -x 100 -y 35 -anchor nw -bordermode ignore 
    place $base.fra68.fra107.ent109 \
        -x 100 -y 60 -anchor nw -bordermode ignore 
    place $base.fra68.fra107.ent110 \
        -x 100 -y 85 -anchor nw -bordermode ignore 
    place $base.fra68.fra107.lab111 \
        -x 10 -y 35 -width 56 -height 24 -anchor nw -bordermode ignore 
    place $base.fra68.fra107.lab112 \
        -x 10 -y 60 -width 71 -height 24 -anchor nw -bordermode ignore 
    place $base.fra68.fra107.lab113 \
        -x 10 -y 85 -width 76 -height 24 -anchor nw -bordermode ignore 
    place $base.fra68.fra107.lab37 \
        -x 250 -y 10 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.fra68.fra107.lab38 \
        -x 250 -y 35 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.fra68.fra107.lab39 \
        -x 250 -y 60 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.fra68.fra107.lab40 \
        -x 250 -y 85 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.011 \
        -x 10 -y 35 -width 735 -height 385 -anchor nw -bordermode ignore 
    place $base.011.fra80 \
        -x 10 -y 10 -width 715 -height 165 -anchor nw -bordermode ignore 
    place $base.011.fra80.lab85 \
        -x 5 -y 5 -width 116 -height 24 -anchor nw -bordermode ignore 
    place $base.011.fra80.lab86 \
        -x 25 -y 30 -width 46 -height 24 -anchor nw -bordermode ignore 
    place $base.011.fra80.lab87 \
        -x 25 -y 55 -width 91 -height 24 -anchor nw -bordermode ignore 
    place $base.011.fra80.lab88 \
        -x 25 -y 80 -width 71 -height 24 -anchor nw -bordermode ignore 
    place $base.011.fra80.lab89 \
        -x 25 -y 105 -width 111 -height 24 -anchor nw -bordermode ignore 
    place $base.011.fra80.lab90 \
        -x 25 -y 130 -width 111 -height 24 -anchor nw -bordermode ignore 
    place $base.011.fra80.ent91 \
        -x 140 -y 30 -anchor nw -bordermode ignore 
    place $base.011.fra80.ent92 \
        -x 140 -y 55 -anchor nw -bordermode ignore 
    place $base.011.fra80.ent93 \
        -x 140 -y 80 -anchor nw -bordermode ignore 
    place $base.011.fra80.ent94 \
        -x 140 -y 105 -anchor nw -bordermode ignore 
    place $base.011.fra80.ent95 \
        -x 140 -y 130 -anchor nw -bordermode ignore 
    place $base.011.fra80.lab28 \
        -x 290 -y 30 -width 46 -height 23 -anchor nw -bordermode ignore 
    place $base.011.fra80.lab29 \
        -x 290 -y 55 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.011.fra80.lab30 \
        -x 290 -y 80 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.011.fra80.lab31 \
        -x 290 -y 105 -width 76 -height 23 -anchor nw -bordermode ignore 
    place $base.011.fra80.lab32 \
        -x 290 -y 130 -width 76 -height 23 -anchor nw -bordermode ignore 
    place $base.011.fra83 \
        -x 10 -y 185 -width 715 -height 115 -anchor nw -bordermode ignore 
    place $base.011.fra83.lab97 \
        -x 25 -y 30 -width 56 -height 24 -anchor nw -bordermode ignore 
    place $base.011.fra83.lab98 \
        -x 25 -y 55 -width 66 -height 24 -anchor nw -bordermode ignore 
    place $base.011.fra83.lab99 \
        -x 25 -y 80 -width 66 -height 24 -anchor nw -bordermode ignore 
    place $base.011.fra83.lab100 \
        -x 5 -y 5 -width 116 -height 24 -anchor nw -bordermode ignore 
    place $base.011.fra83.ent101 \
        -x 140 -y 30 -anchor nw -bordermode ignore 
    place $base.011.fra83.ent102 \
        -x 140 -y 55 -anchor nw -bordermode ignore 
    place $base.011.fra83.ent103 \
        -x 140 -y 80 -anchor nw -bordermode ignore 
    place $base.011.fra83.lab33 \
        -x 290 -y 30 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.011.fra83.lab34 \
        -x 290 -y 55 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.011.fra83.lab35 \
        -x 290 -y 80 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.011.fra84 \
        -x 10 -y 310 -width 715 -height 65 -anchor nw -bordermode ignore 
    place $base.011.fra84.lab104 \
        -x 5 -y 5 -width 116 -height 24 -anchor nw -bordermode ignore 
    place $base.011.fra84.lab105 \
        -x 25 -y 30 -width 56 -height 24 -anchor nw -bordermode ignore 
    place $base.011.fra84.ent106 \
        -x 140 -y 30 -anchor nw -bordermode ignore 
    place $base.011.fra84.lab36 \
        -x 290 -y 30 -width 36 -height 23 -anchor nw -bordermode ignore 
    place $base.fra33 \
        -x 10 -y 35 -width 735 -height 385 -anchor nw -bordermode ignore 
    place $base.fra33.fra77 \
        -x 10 -y 10 -width 715 -height 35 -anchor nw -bordermode ignore 
    place $base.fra33.fra77.lab78 \
        -x 5 -y 5 -width 146 -height 24 -anchor nw -bordermode ignore 
    place $base.fra33.fra77.ent79 \
        -x 155 -y 5 -anchor nw -bordermode ignore 
    place $base.fra33.fra77.lab27 \
        -x 305 -y 5 -width 76 -height 23 -anchor nw -bordermode ignore 
    place $base.01 \
        -x 10 -y 430 -width 84 -height 34 -anchor nw -bordermode ignore 
    place $base.02 \
        -x 100 -y 430 -width 84 -height 34 -anchor nw -bordermode ignore 
    place $base.but96 \
        -x 190 -y 430 -width 84 -height 34 -anchor nw -bordermode ignore 
    place $base.03 \
        -x 550 -y 430 -width 94 -height 34 -anchor nw -bordermode ignore 
    place $base.05 \
        -x 650 -y 430 -width 94 -height 34 -anchor nw -bordermode ignore 
    place $base.06 \
        -x 5 -y 5 -width 103 -height 30 -anchor nw -bordermode ignore 
    place $base.07 \
        -x 110 -y 5 -width 212 -height 30 -anchor nw -bordermode ignore 
    place $base.08 \
        -x 325 -y 5 -width 140 -height 30 -anchor nw -bordermode ignore 
    place $base.09 \
        -x 467 -y 5 -width 101 -height 30 -anchor nw -bordermode ignore 
    place $base.010 \
        -x 570 -y 5 -width 96 -height 30 -anchor nw -bordermode ignore 
    place $base.fra35 \
        -x 10 -y 35 -width 735 -height 385 -anchor nw -bordermode ignore 
    place $base.fra35.fra39 \
        -x 10 -y 10 -width 715 -height 165 -anchor nw -bordermode ignore 
    place $base.fra35.fra39.lab40 \
        -x 5 -y 5 -width 46 -height 24 -anchor nw -bordermode ignore 
    place $base.fra35.fra39.lab41 \
        -x 5 -y 30 -width 71 -height 24 -anchor nw -bordermode ignore 
    place $base.fra35.fra39.lab42 \
        -x 5 -y 55 -width 71 -height 24 -anchor nw -bordermode ignore 
    place $base.fra35.fra39.ent43 \
        -x 100 -y 5 -anchor nw -bordermode ignore 
    place $base.fra35.fra39.ent44 \
        -x 100 -y 30 -anchor nw -bordermode ignore 
    place $base.fra35.fra39.tex28 \
        -x 100 -y 55 -width 150 -height 102 -anchor nw -bordermode ignore 

    focus .top17.fra35.fra39.ent43
}

Window show .
Window show .top17

main $argc $argv
