#!/usr/local/bin/wish
#############################################################################
# Visual Tcl v1.10 Project
#

#################################
# GLOBAL VARIABLES
#
global S_catchment; 
global S_substance; 
global S_title; 
global catchlist; 
global filename; 
global op_title; 
global sublist; 
global widget; 

#################################
# USER DEFINED PROCEDURES
#
proc init {argc argv} {
global filename op_title S_title S_catchment S_substance
global catchlist sublist

#default: initialize catchment and substance list 
set catchlist {}
set sublist {"<none>"}

if { $argv == "" } {
	set filename ""
	set op_title "Test Mode (no filename)"
	set S_title "Test Scenario (no filename)"
	set S_catchment "<none>"
	set S_substance "<none>"
	lappend catchlist "scenario1"  "scenario2"
	lappend sublist   "substance 1" "substance 2"
} else {
	set filename $argv

	set datafile [ open $filename r ]

	gets $datafile op_title
	gets $datafile S_title
	gets $datafile S_catchment
	gets $datafile S_substance

	gets $datafile count

	for { set i 0 } { $i < $count } { incr i } {
		gets $datafile ca
		lappend catchlist $ca
	}
	
	gets $datafile count

	for { set i 0 } { $i < $count } { incr i } {
		gets $datafile su
		lappend sublist $su
	}

	close $datafile

        # empty the transfer file
        set datafile [ open $filename w ]
        close $datafile

}
}

init $argc $argv


proc saveData {} {
global filename S_title S_catchment S_substance

if { $filename != "" } {
	set datafile [ open $filename w ]

	puts $datafile $S_title
	puts $datafile $S_catchment
	puts $datafile $S_substance

	close $datafile
}
}

proc OKproc {} {
	global S_title S_catchment
        if { $S_title != "" } { saveData; destroy . } else {
		tk_messageBox -type ok -icon warning  \
		-title  "Scenario Editor - Data incomplete"  \
		-message "You have to specify a scenario name.
Substance and catchment selection is optional."  } 
	}
 
proc main {argc argv} {
global catchlist sublist

	foreach c $catchlist {
		.top17.fra22.men23.m add command   \
			-command "set S_catchment {$c}"  -label $c
	}

	foreach s $sublist {
		.top17.fra28.men24.m add command   \
			-command "set S_substance {$s}"  -label $s
	}
}

proc Window {args} {
global vTcl
    set cmd [lindex $args 0]
    set name [lindex $args 1]
    set newname [lindex $args 2]
    set rest [lrange $args 3 end]
    if {$name == "" || $cmd == ""} {return}
    if {$newname == ""} {
        set newname $name
    }
    set exists [winfo exists $newname]
    switch $cmd {
        show {
            if {$exists == "1" && $name != "."} {wm deiconify $name; return}
            if {[info procs vTclWindow(pre)$name] != ""} {
                eval "vTclWindow(pre)$name $newname $rest"
            }
            if {[info procs vTclWindow$name] != ""} {
                eval "vTclWindow$name $newname $rest"
            }
            if {[info procs vTclWindow(post)$name] != ""} {
                eval "vTclWindow(post)$name $newname $rest"
            }
        }
        hide    { if $exists {wm withdraw $newname; return} }
        iconify { if $exists {wm iconify $newname; return} }
        destroy { if $exists {destroy $newname; return} }
    }
}

#################################
# VTCL GENERATED GUI PROCEDURES
#

proc vTclWindow. {base} {
    if {$base == ""} {
        set base .
    }
    ###################
    # CREATING WIDGETS
    ###################
    wm focusmodel $base passive
    wm geometry $base 200x200+0+0
    wm maxsize $base 1156 867
    wm minsize $base 104 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm withdraw $base
    wm title $base "C:Programmet-1.08t.tcl"
    ###################
    # SETTING GEOMETRY
    ###################
}

proc vTclWindow.top17 {base} {
    if {$base == ""} {
        set base .top17
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 488x192+90+193
    wm maxsize $base 1156 867
    wm minsize $base 104 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Scenario Editor"
    label $base.lab19 \
        -justify left \
        -text Title: 
    entry $base.ent20 \
        -textvariable S_title 
    frame $base.fra22 \
        -borderwidth 1 -height 30 -relief sunken -width 30 
    label $base.fra22.lab23 \
        -text Catchment: 
    menubutton $base.fra22.men23 \
        -anchor nw \
        -indicatoron 1 -justify left -menu .top17.fra22.men23.m -padx 4 \
        -pady 3 -relief raised -textvariable S_catchment 
    menu $base.fra22.men23.m \
        -borderwidth 1 \
        -tearoff 0 
    frame $base.fra28 \
        -borderwidth 1 -height 30 -relief sunken -width 30 
    label $base.fra28.lab29 \
        -text Substance: 
    menubutton $base.fra28.men24 \
        -anchor nw \
        -indicatoron 1 -justify left -menu .top17.fra28.men24.m -padx 4 \
        -pady 3 -relief raised -textvariable S_substance 
    menu $base.fra28.men24.m \
        -borderwidth 1 \
        -tearoff 0 
    button $base.but33 \
        -command OKproc \
        -padx 10 \
        -pady 3 -text OK 
    button $base.but34 \
        -command {destroy .} \
        -padx 10 \
        -pady 3 -text Cancel 
    frame $base.fra20 \
        -borderwidth 2 -height 75 -relief groove -width 125 
    label $base.fra20.lab21 \
        -anchor nw -borderwidth 1 \
        -justify left \
        -text {Please specify a scenario title and select a catchment.} 
    label $base.fra20.lab22 \
        -anchor nw -borderwidth 1 \
        -justify left \
        -text {Optionally You may select a substance.} 
    button $base.but25 \
        -command { tk_messageBox -title "Scenario Editor - Help"  \
		-icon info -type ok \
		-message "A help system is not yet supported. 
In a future release it will be possible to browse help files in HTML format." }\
        -padx 9 -pady 3 \
        -text Help 
    
    bind all <Escape> {
	destroy .
	}

    bind all <Return> {
	OKproc
	}
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.lab19 \
        -x 10 -y 70 -width 33 -height 26 -anchor nw -bordermode ignore 
    place $base.ent20 \
        -x 50 -y 70 -width 321 -height 25 -anchor nw -bordermode ignore 
    place $base.fra22 \
        -x 5 -y 105 -width 365 -height 35 -anchor nw -bordermode ignore 
    place $base.fra22.lab23 \
        -x 5 -y 5 -width 76 -height 26 -anchor nw -bordermode ignore 
    place $base.fra22.men23 \
        -x 85 -y 5 -width 268 -height 25 -anchor nw -bordermode ignore 
    place $base.fra28 \
        -x 5 -y 150 -width 365 -height 35 -anchor nw -bordermode ignore 
    place $base.fra28.lab29 \
        -x 5 -y 5 -width 70 -height 26 -anchor nw -bordermode ignore 
    place $base.fra28.men24 \
        -x 85 -y 5 -width 270 -height 25 -anchor nw -bordermode ignore 
    place $base.but33 \
        -x 380 -y 5 -width 100 -height 35 -anchor nw -bordermode ignore 
    place $base.but34 \
        -x 380 -y 45 -width 100 -height 35 -anchor nw -bordermode ignore 
    place $base.fra20 \
        -x 5 -y 5 -width 365 -height 55 -anchor nw -bordermode ignore 
    place $base.fra20.lab21 \
        -x 5 -y 5 -anchor nw -bordermode ignore 
    place $base.fra20.lab22 \
        -x 5 -y 30 -anchor nw -bordermode ignore 
    place $base.but25 \
        -x 380 -y 85 -width 100 -height 35 -anchor nw -bordermode ignore 
}

Window show .
Window show .top17

main $argc $argv
