#!/usr/local/bin/wish
#############################################################################
# Visual Tcl v1.10 Project
#

#################################
# GLOBAL VARIABLES
#
global CS_Q_DWF_Q95; 
global CS_Q_DWF_mean; 
global T_air; 
global T_water; 
global corr_BOD; 
global corr_DO; 
global corr_SS; 
global corr_k_SS; 
global corr_temp; 
global corr_wind; 
global filename; 
global v_wind; 
global widget; 

#################################
# USER DEFINED PROCEDURES
#
proc init {argc argv} {
global filename 
global T_water T_air v_wind CS_Q_DWF_mean CS_Q_DWF_Q95
global corr_temp corr_wind corr_SS corr_DO corr_BOD corr_k_SS

if { $argv == "" } {
	set filename ""

	set T_water "unknown"
	set T_air "unknown"
	set v_wind "unknown"
	set CS_Q_DWF_mean "unknown"
	set CS_Q_DWF_Q95 "unknown"
	set corr_temp "unknown"
	set corr_wind "unknown"
	set corr_SS "unknown"
	set corr_DO "unknown"
	set corr_BOD "unknown"
	set corr_k_SS "unknown"
} else {
	set filename $argv

	set datafile [ open $filename r ]

	gets $datafile T_water
	gets $datafile T_air
	gets $datafile v_wind
	gets $datafile CS_Q_DWF_mean
	gets $datafile CS_Q_DWF_Q95
	gets $datafile corr_temp
	gets $datafile corr_wind
	gets $datafile corr_SS
	gets $datafile corr_DO
	gets $datafile corr_BOD
	gets $datafile corr_k_SS

	close $datafile

        # empty the transfer file
        set datafile [ open $filename w ]
        close $datafile
}
}

init $argc $argv


proc saveData {} {
global filename
global T_water T_air v_wind CS_Q_DWF_mean CS_Q_DWF_Q95
global corr_temp corr_wind corr_SS corr_DO corr_BOD corr_k_SS

if { $filename != "" } {
	set datafile [ open $filename w ]

	puts $datafile $T_water
	puts $datafile $T_air
	puts $datafile $v_wind
	puts $datafile $CS_Q_DWF_mean
	puts $datafile $CS_Q_DWF_Q95
	puts $datafile $corr_temp
	puts $datafile $corr_wind
	puts $datafile $corr_SS
	puts $datafile $corr_DO
	puts $datafile $corr_BOD
	puts $datafile $corr_k_SS

	close $datafile
}
}

proc main {argc argv} {

}

proc Window {args} {
global vTcl
    set cmd [lindex $args 0]
    set name [lindex $args 1]
    set newname [lindex $args 2]
    set rest [lrange $args 3 end]
    if {$name == "" || $cmd == ""} {return}
    if {$newname == ""} {
        set newname $name
    }
    set exists [winfo exists $newname]
    switch $cmd {
        show {
            if {$exists == "1" && $name != "."} {wm deiconify $name; return}
            if {[info procs vTclWindow(pre)$name] != ""} {
                eval "vTclWindow(pre)$name $newname $rest"
            }
            if {[info procs vTclWindow$name] != ""} {
                eval "vTclWindow$name $newname $rest"
            }
            if {[info procs vTclWindow(post)$name] != ""} {
                eval "vTclWindow(post)$name $newname $rest"
            }
        }
        hide    { if $exists {wm withdraw $newname; return} }
        iconify { if $exists {wm iconify $newname; return} }
        destroy { if $exists {destroy $newname; return} }
    }
}

#################################
# VTCL GENERATED GUI PROCEDURES
#

proc vTclWindow. {base} {
    if {$base == ""} {
        set base .
    }
    ###################
    # CREATING WIDGETS
    ###################
    wm focusmodel $base passive
    wm geometry $base 200x200+0+0
    wm maxsize $base 1156 867
    wm minsize $base 104 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm withdraw $base
    wm title $base "C:Programmetclt.tcl"
    ###################
    # SETTING GEOMETRY
    ###################
}

proc vTclWindow.top17 {base} {
    if {$base == ""} {
        set base .top17
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 671x405+108+172
    wm maxsize $base 1156 867
    wm minsize $base 104 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Model Parameters"
    button $base.but54 \
        -command {saveData;
destroy .} \
        -padx 10 -pady 3 \
        -text OK 
    button $base.but55 \
        -command {destroy .} \
        -padx 10 -pady 3 \
        -text Cancel 
    button $base.but22 \
        -command {tk_messageBox -title "Model Parameters - Help" \
		-message {A help system for this dialog is not yet supported.
In a future release it will be possible to browse help files in HTML format.}} \
        -padx 11 \
        -pady 4 -text Help 
    frame $base.fra17 \
        -borderwidth 1 -height 75 -relief sunken -width 125 
    frame $base.fra17.fra18 \
        -borderwidth 1 -height 30 -relief sunken -width 30 
    label $base.fra17.fra18.01 \
        -text {General environmental parameters} 
    label $base.fra17.fra18.02 \
        -anchor w \
        -text {Temperature water} 
    label $base.fra17.fra18.03 \
        -anchor w \
        -text {Wind speed:} 
    label $base.fra17.fra18.04 \
        -anchor w \
        -text {Combined sewer Q_mean as fraction of DWF:} 
    label $base.fra17.fra18.05 \
        -anchor w \
        -text {Combined sewer Q_95 as fraction of DWF:} 
    entry $base.fra17.fra18.06 \
        -textvariable T_water 
    entry $base.fra17.fra18.015 \
        -textvariable T_air 
    entry $base.fra17.fra18.07 \
        -textvariable v_wind 
    entry $base.fra17.fra18.08 \
        -textvariable CS_Q_DWF_mean 
    entry $base.fra17.fra18.09 \
        -textvariable CS_Q_DWF_Q95 
    label $base.fra17.fra18.010 \
        -anchor w \
        -text {[ oC ]} 
    label $base.fra17.fra18.011 \
        -anchor w \
        -text {[ m/s ]} 
    label $base.fra17.fra18.012 \
        -anchor w \
        -text {[ - ]} 
    label $base.fra17.fra18.013 \
        -anchor w \
        -text {[ - ]} 
    label $base.fra17.fra18.014 \
        -anchor w \
        -text {Temperature air:} 
    label $base.fra17.fra18.016 \
        -anchor w \
        -text {[ oC ]} 
    frame $base.fra17.fra19 \
        -borderwidth 1 -height 30 -relief sunken -width 30 
    label $base.fra17.fra19.01 \
        -text {Correlations to river flow} 
    label $base.fra17.fra19.02 \
        -anchor w \
        -text {Temperature - flow:} 
    label $base.fra17.fra19.03 \
        -anchor w \
        -text {Wind speed - flow:} 
    label $base.fra17.fra19.04 \
        -anchor w \
        -text {River suspended solids - flow:} 
    label $base.fra17.fra19.05 \
        -anchor w \
        -text {River dissolved O_2 - flow:} 
    label $base.fra17.fra19.06 \
        -anchor w \
        -text {River BOD - flow:} 
    label $base.fra17.fra19.07 \
        -anchor w \
        -text {River SS settling rate - flow:} 
    entry $base.fra17.fra19.08 \
        -textvariable corr_temp 
    entry $base.fra17.fra19.09 \
        -textvariable corr_wind 
    entry $base.fra17.fra19.010 \
        -textvariable corr_SS 
    entry $base.fra17.fra19.011 \
        -textvariable corr_DO 
    entry $base.fra17.fra19.012 \
        -textvariable corr_BOD 
    entry $base.fra17.fra19.013 \
        -textvariable corr_k_SS 
    label $base.fra17.fra19.014 \
        -anchor w \
        -text {[ - ]} 
    label $base.fra17.fra19.015 \
        -anchor w \
        -text {[ - ]} 
    label $base.fra17.fra19.016 \
        -anchor w \
        -text {[ - ]} 
    label $base.fra17.fra19.017 \
        -anchor w \
        -text {[ - ]} 
    label $base.fra17.fra19.018 \
        -anchor w \
        -text {[ - ]} 
    label $base.fra17.fra19.019 \
        -anchor w \
        -text {[ - ]} 
    button $base.but18 \
        -command {tk_messageBox -title "Model Parameters - Estimate Info" \
		-message {This functionality is not yet supported.
It will make it possible to automatically estimate\
			the values of certain model parameters.}} \
        -padx 11 -pady 4 \
        -text Estimate 
    button $base.but19 \
        -command {tk_messageBox -title "Model Parameters - Distribution Info" \
		-message {This functionality is not yet supported.
It will make it possible to select one of the\
			distribution types, provided by the stochastic model,\
			for the current parameter.
Depending on the selected type further dialog boxes\
			will raise to ask for needed parameters.}} \
        -padx 11 -pady 4 \
        -text Distribution 

    bind all <Escape> {
	destroy .
	}
    bind all <Return> {
	saveData
	destroy .
	}
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.but54 \
        -x 570 -y 10 -width 94 -height 34 -anchor nw -bordermode ignore 
    place $base.but55 \
        -x 570 -y 50 -width 94 -height 34 -anchor nw -bordermode ignore 
    place $base.but22 \
        -x 570 -y 90 -width 94 -height 34 -anchor nw -bordermode ignore 
    place $base.fra17 \
        -x 5 -y 10 -width 555 -height 385 -anchor nw -bordermode ignore 
    place $base.fra17.fra18 \
        -x 10 -y 10 -width 535 -height 170 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.01 \
        -x 5 -y 5 -width 245 -height 22 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.02 \
        -x 25 -y 30 -width 128 -height 21 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.03 \
        -x 25 -y 80 -width 86 -height 21 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.04 \
        -x 25 -y 115 -width 297 -height 21 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.05 \
        -x 25 -y 140 -width 284 -height 21 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.06 \
        -x 325 -y 30 -width 150 -height 25 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.015 \
        -x 325 -y 55 -width 150 -height 25 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.07 \
        -x 325 -y 80 -width 150 -height 25 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.08 \
        -x 325 -y 115 -width 150 -height 25 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.09 \
        -x 325 -y 140 -width 150 -height 25 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.010 \
        -x 475 -y 30 -width 43 -height 21 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.011 \
        -x 475 -y 80 -width 48 -height 21 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.012 \
        -x 475 -y 115 -width 33 -height 21 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.013 \
        -x 475 -y 140 -width 40 -height 20 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.014 \
        -x 25 -y 55 -width 118 -height 21 -anchor nw -bordermode ignore 
    place $base.fra17.fra18.016 \
        -x 475 -y 55 -width 38 -height 21 -anchor nw -bordermode ignore 
    place $base.fra17.fra19 \
        -x 10 -y 190 -width 535 -height 185 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.01 \
        -x 5 -y 5 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.02 \
        -x 25 -y 30 -width 130 -height 20 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.03 \
        -x 25 -y 55 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.04 \
        -x 25 -y 80 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.05 \
        -x 25 -y 105 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.06 \
        -x 25 -y 130 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.07 \
        -x 25 -y 155 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.08 \
        -x 325 -y 30 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.09 \
        -x 325 -y 55 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.010 \
        -x 325 -y 80 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.011 \
        -x 325 -y 105 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.012 \
        -x 325 -y 130 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.013 \
        -x 325 -y 155 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.014 \
        -x 475 -y 30 -width 35 -height 20 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.015 \
        -x 475 -y 55 -width 35 -height 20 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.016 \
        -x 475 -y 80 -width 35 -height 20 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.017 \
        -x 475 -y 105 -width 35 -height 20 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.018 \
        -x 475 -y 130 -width 35 -height 20 -anchor nw -bordermode ignore 
    place $base.fra17.fra19.019 \
        -x 475 -y 155 -width 35 -height 20 -anchor nw -bordermode ignore 
    place $base.but18 \
        -x 570 -y 320 -width 94 -height 34 -anchor nw -bordermode ignore 
    place $base.but19 \
        -x 570 -y 360 -width 94 -height 34 -anchor nw -bordermode ignore 
}

Window show .
Window show .top17

main $argc $argv
