#!/usr/local/bin/wish
#############################################################################
# Visual Tcl v1.10 Project
#

#################################
# GLOBAL VARIABLES
#
global MC_Shots; 
global bioModel; 
global filename; 
global hydrolysisModel; 
global k; 
global k_deg; 
global k_vol; 
global photoBioModel; 
global sedimentationModel; 
global selectedModelMode; 
global volatilizationModel; 
global widget; 

#################################
# USER DEFINED PROCEDURES
#
proc init {argc argv} {
global filename selectedModelMode MC_Shots
global k k_vol k_deg
global volatilizationModel sedimentationModel bioModel
global photoBioModel hydrolysisModel

if { $argv == "" } {
	set filename ""
	set selectedModelMode 1
	set MC_Shots "unknown"
	set k "unknown"
	set k_vol "unknown"
	set k_deg "unknown"
	set volatilizationModel 0
	set sedimentationModel 0
	set bioModel 0
	set photoBioModel 0
	set hydrolysisModel 0
} else {
	set filename $argv

	set datafile [ open $filename r ]

	gets $datafile selectedModelMode
	if { $selectedModelMode == "unknown" } { set selectedModelMode 1 }

	gets $datafile MC_Shots

	gets $datafile k
	gets $datafile k_vol
	gets $datafile k_deg

	gets $datafile volatilizationModel
	if { $volatilizationModel == "unknown" } { set volatilizationModel 0 }
	gets $datafile sedimentationModel
	if { $sedimentationModel == "unknown" } { set sedimentationModel 0 }
	gets $datafile bioModel
	if { $bioModel == "unknown" } { set bioModel 0 }
	gets $datafile photoBioModel
	if { $photoBioModel == "unknown" } { set photoBioModel 0 }
	gets $datafile hydrolysisModel
	if { $hydrolysisModel == "unknown" } { set hydrolysisModel 0 }

	close $datafile

        # empty the transfer file
        set datafile [ open $filename w ]
        close $datafile
}
}

init $argc $argv


proc disable_Mode1 {} {
set f ".top17.fra18.fra26"

	$f.ent28 config -foreground #808080 -state disabled
	$f.lab29 config -foreground #808080
}

proc disable_Mode2 {} {
set f ".top17.fra18.fra31"

	$f.ent33 config -foreground #808080 -state disabled
	$f.lab35 config -foreground #808080

	$f.ent34 config -foreground #808080 -state disabled
	$f.lab36 config -foreground #808080
}

proc disable_Mode3 {} {
set f ".top17.fra18.fra37"

	$f.che39 config -state disabled
	$f.che40 config -state disabled
	$f.che41 config -state disabled
	$f.che42 config -state disabled
	$f.che43 config -state disabled

}

proc enable_Mode1 {} {
set f ".top17.fra18.fra26"

	$f.ent28 config -foreground #000000 -state normal
	$f.lab29 config -foreground #000000
}

proc enable_Mode2 {} {
set f ".top17.fra18.fra31"

	$f.ent33 config -foreground #000000 -state normal
	$f.lab35 config -foreground #000000

	$f.ent34 config -foreground #000000 -state normal
	$f.lab36 config -foreground #000000
}

proc enable_Mode3 {} {
set f ".top17.fra18.fra37"

	$f.che39 config -state normal
	$f.che40 config -state normal
	$f.che41 config -state normal
	$f.che42 config -state normal
	$f.che43 config -state normal

}

proc saveData {} {
global filename selectedModelMode MC_Shots
global k k_vol k_deg
global volatilizationModel sedimentationModel bioModel
global photoBioModel hydrolysisModel

if { $filename != "" } {
	set datafile [ open $filename w ]

	puts $datafile $selectedModelMode

	puts $datafile $MC_Shots

	puts $datafile $k
	puts $datafile $k_vol
	puts $datafile $k_deg

	puts $datafile $volatilizationModel
	puts $datafile $sedimentationModel
	puts $datafile $bioModel
	puts $datafile $photoBioModel
	puts $datafile $hydrolysisModel

	close $datafile
}
}

proc stateControl {mode} {
switch $mode {
    1
        { enable_Mode1; disable_Mode2; disable_Mode3 }
    2
        { enable_Mode2; disable_Mode1; disable_Mode3 }
    3
        { enable_Mode3; disable_Mode1; disable_Mode2 }
}
}

proc main {argc argv} {
global selectedModelMode

stateControl $selectedModelMode
}

proc Window {args} {
global vTcl
    set cmd [lindex $args 0]
    set name [lindex $args 1]
    set newname [lindex $args 2]
    set rest [lrange $args 3 end]
    if {$name == "" || $cmd == ""} {return}
    if {$newname == ""} {
        set newname $name
    }
    set exists [winfo exists $newname]
    switch $cmd {
        show {
            if {$exists == "1" && $name != "."} {wm deiconify $name; return}
            if {[info procs vTclWindow(pre)$name] != ""} {
                eval "vTclWindow(pre)$name $newname $rest"
            }
            if {[info procs vTclWindow$name] != ""} {
                eval "vTclWindow$name $newname $rest"
            }
            if {[info procs vTclWindow(post)$name] != ""} {
                eval "vTclWindow(post)$name $newname $rest"
            }
        }
        hide    { if $exists {wm withdraw $newname; return} }
        iconify { if $exists {wm iconify $newname; return} }
        destroy { if $exists {destroy $newname; return} }
    }
}

#################################
# VTCL GENERATED GUI PROCEDURES
#

proc vTclWindow. {base} {
    if {$base == ""} {
        set base .
    }
    ###################
    # CREATING WIDGETS
    ###################
    wm focusmodel $base passive
    wm geometry $base 200x200+0+0
    wm maxsize $base 1156 867
    wm minsize $base 112 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm withdraw $base
    wm title $base "C:ProgrammeTCLt-1.08t.tcl"
    ###################
    # SETTING GEOMETRY
    ###################
}

proc vTclWindow.top17 {base} {
    if {$base == ""} {
        set base .top17
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 549x409+43+189
    wm maxsize $base 1156 867
    wm minsize $base 112 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Model Mode Selection"
    frame $base.fra18 \
        -borderwidth 1 -height 30 -relief sunken -width 30 
    frame $base.fra18.fra17 \
        -borderwidth 1 -height 30 -relief sunken -width 30 
    entry $base.fra18.fra17.ent18 \
        -textvariable MC_Shots 
    label $base.fra18.fra17.lab21 \
        -anchor w  \
        -foreground #000000 -highlightcolor #000000 -justify left \
        -text {Monte-Carlo Shots [ - ]} 
    frame $base.fra18.fra26 \
        -borderwidth 1 -height 30 -relief sunken -width 30 
    radiobutton $base.fra18.fra26.rad27 \
        -activebackground #c0c0c0 -command {stateControl $selectedModelMode} \
        -text {Mode 1} \
        -value 1 -variable selectedModelMode 
    entry $base.fra18.fra26.ent28 \
        -textvariable k 
    label $base.fra18.fra26.lab29 \
        -anchor w \
        -foreground #000000 -highlightcolor #000000 -justify left \
        -text {lumped 1st order in-stream removal rate [1/h]} 
    frame $base.fra18.fra31 \
        -borderwidth 1 -height 30 -relief sunken -width 30 
    radiobutton $base.fra18.fra31.rad32 \
        -activebackground #c0c0c0 -command {stateControl $selectedModelMode} \
        -text {Mode 2} \
        -value 2 -variable selectedModelMode 
    entry $base.fra18.fra31.ent33 \
        -foreground #808080 -state disabled -textvariable k_vol 
    entry $base.fra18.fra31.ent34 \
        -foreground #808080 -state disabled -textvariable k_deg 
    label $base.fra18.fra31.lab35 \
        -anchor w  \
        -foreground #808080 -justify left \
        -text {1st order volatilization rate in rivers [1/h]} 
    label $base.fra18.fra31.lab36 \
        -anchor w  \
        -foreground #808080 -justify left \
        -text {1st order degradation rate in rivers [1/h]} 
    frame $base.fra18.fra37 \
        -borderwidth 1 -height 30 -relief sunken -width 30 
    radiobutton $base.fra18.fra37.rad38 \
        -activebackground #c0c0c0 -command {stateControl $selectedModelMode} \
        -text {Mode 3} \
        -value 3 -variable selectedModelMode 
    checkbutton $base.fra18.fra37.che43 \
        -activebackground #c0c0c0 \
        -state disabled -text {volatilization model} \
        -variable volatilizationModel 
    checkbutton $base.fra18.fra37.che42 \
        -activebackground #c0c0c0 \
        -state disabled -text {sedimentation model} \
        -variable sedimentationModel 
    checkbutton $base.fra18.fra37.che41 \
        -activebackground #c0c0c0 \
        -state disabled -text {biodegradation model} \
        -variable bioModel 
    checkbutton $base.fra18.fra37.che40 \
        -activebackground #c0c0c0 \
        -state disabled \
        -text {photo-biodegradation model} -variable photoBioModel 
    checkbutton $base.fra18.fra37.che39 \
        -activebackground #c0c0c0 \
        -state disabled -text {hydrolysis model} \
        -variable hydrolysisModel 
    frame $base.fra45 \
        -borderwidth 1 -height 30 -width 30 
    button $base.fra45.but47 \
        -activebackground #c0c0c0 -command {saveData; 
destroy .} \
         -padx 10 \
        -pady 3 -text OK 
    button $base.fra45.but46 \
        -activebackground #c0c0c0 -command { destroy . } \
         -padx 10 \
        -pady 3 -text Cancel 
    button $base.but23 \
        \
        -command {tk_messageBox -title "Model Mode - Help"  -message {A help system for this dialog is not yet supported.
In a future release it will be possible to browse  help files in HTML format.}} \
        -padx 11 -pady 4 \
        -text Help 
    button $base.but17 \
        \
        -command {tk_messageBox -title "Model Mode - Distribution Info"  -message {This functionality is not yet supported.
It will make it possible to select one of the distribution types, provided \
by the stochastic model, for the current parameter.
Depending on the selected type further dialog boxes will raise to ask for needed parameters.}} \
        -padx 11 -pady 4 \
        -text Distribution 

    bind all <Escape> {
	destroy .
	}
    bind all <Return> {
	saveData
	destroy .
	}
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.fra18 \
        -x 5 -y 10 -width 425 -height 390 -anchor nw -bordermode ignore 
    place $base.fra18.fra17 \
        -x 10 -y 9 -width 405 -height 35 -anchor nw -bordermode ignore 
    place $base.fra18.fra17.ent18 \
        -x 35 -y 6 -width 65 -height 25 -anchor nw -bordermode ignore 
    place $base.fra18.fra17.lab21 \
        -x 101 -y 6 -width 158 -height 26 -anchor nw -bordermode ignore 
    place $base.fra18.fra26 \
        -x 10 -y 53 -width 405 -height 60 -anchor nw -bordermode ignore 
    place $base.fra18.fra26.rad27 \
        -x 5 -y 5 -anchor nw -bordermode ignore 
    place $base.fra18.fra26.ent28 \
        -x 35 -y 30 -width 65 -height 25 -anchor nw -bordermode ignore 
    place $base.fra18.fra26.lab29 \
        -x 100 -y 30 -width 298 -height 26 -anchor nw -bordermode ignore 
    place $base.fra18.fra31 \
        -x 10 -y 123 -width 405 -height 85 -anchor nw -bordermode ignore 
    place $base.fra18.fra31.rad32 \
        -x 5 -y 5 -anchor nw -bordermode ignore 
    place $base.fra18.fra31.ent33 \
        -x 35 -y 30 -width 65 -height 25 -anchor nw -bordermode ignore 
    place $base.fra18.fra31.ent34 \
        -x 35 -y 55 -width 65 -height 25 -anchor nw -bordermode ignore 
    place $base.fra18.fra31.lab35 \
        -x 100 -y 30 -width 263 -height 26 -anchor nw -bordermode ignore 
    place $base.fra18.fra31.lab36 \
        -x 100 -y 55 -width 263 -height 26 -anchor nw -bordermode ignore 
    place $base.fra18.fra37 \
        -x 10 -y 218 -width 405 -height 160 -anchor nw -bordermode ignore 
    place $base.fra18.fra37.rad38 \
        -x 5 -y 5 -anchor nw -bordermode ignore 
    place $base.fra18.fra37.che43 \
        -x 40 -y 30 -anchor nw -bordermode ignore 
    place $base.fra18.fra37.che42 \
        -x 40 -y 55 -anchor nw -bordermode ignore 
    place $base.fra18.fra37.che41 \
        -x 40 -y 80 -anchor nw -bordermode ignore 
    place $base.fra18.fra37.che40 \
        -x 40 -y 105 -anchor nw -bordermode ignore 
    place $base.fra18.fra37.che39 \
        -x 40 -y 130 -anchor nw -bordermode ignore 
    place $base.fra45 \
        -x 435 -y 5 -width 105 -height 80 -anchor nw -bordermode ignore 
    place $base.fra45.but47 \
        -x 10 -y 5 -width 95 -height 35 -anchor nw -bordermode ignore 
    place $base.fra45.but46 \
        -x 10 -y 45 -width 95 -height 35 -anchor nw -bordermode ignore 
    place $base.but23 \
        -x 445 -y 90 -width 95 -height 35 -anchor nw -bordermode ignore 
    place $base.but17 \
        -x 445 -y 365 -width 95 -height 35 -anchor nw -bordermode ignore 
}

Window show .
Window show .top17

main $argc $argv
