# $Source: /home/greatdev/src/models/simul/scripts/RCS/mkRivDat.awk,v $

# $Author: jwagner $

# $Revision: 1.1 $
# $Date: 1997/12/04 16:50:51 $
# $Locker:  $

# Converts a VTab.Export River data File to the needs of the simulator.

BEGIN	{
	FS = ","	# set field separator
	getline line	# read and skip the first line
	countRiv = 0
	}

	{
	river[countRiv, "StretchID"]	= $1
	river[countRiv, "Type"]		= $2
	river[countRiv, "IsDisch"]	= $3
	river[countRiv, "Up1"]		= $4
	river[countRiv, "Up2"]		= $5
	river[countRiv, "RivClass"]	= $6
	river[countRiv, "Q50"]		= $7
	river[countRiv, "Q5"]		= $8
	river[countRiv, "v50"]		= $9
	river[countRiv, "v5"]		= $10
	river[countRiv, "RealLength"]	= $11
	river[countRiv, "Depth50"]	= $12
	river[countRiv, "Depth5"]	= $13

	countRiv ++
	}

END	{
	print countRiv
	print "-1"

	for (i = 0;i < countRiv;i ++) {
		printf("	%d	%d	%d	%d	%d	%d	%f	%f		%f	%f	%f	%f	%f	%f	%f	%f	%f	%f	%f	%f	%f	%f\n",
		river[i, "StretchID"], river[i,"Type"], river[i,"IsDisch"],
		river[i,"Up1"], river[i,"Up2"],
		river[i,"RivClass"], river[i,"Q50"],
		river[i,"Q5"], river[i,"v50"],
		river[i,"v5"], river[i,"RealLength"],
		river[i,"Depth50"], river[i,"Depth5"],
		-1, 0,	# SS
		-1, 0,	# DO
		-1, 0,	# BOD
		-1, 0,	# pH
		-1)	# X
	}
	}
