<%@ page import="pms.*,pms.tools.*" %>

<jsp:useBean id="cartaProps" class="pms.CartaProperties" />

<%
  // set up map properties

  cartaProps.setPath(getServletContext().getRealPath(""));
  cartaProps.setView(request.getParameter("VIEW"));
  cartaProps.setExtent(request.getParameter("EXTENT"));
  cartaProps.setSize(request.getParameter("SIZE"));

  String xParam = request.getParameter("MAP.x");
  String yParam = request.getParameter("MAP.y");
  cartaProps.setDisplayCenter(xParam, yParam);

  cartaProps.setAction(request.getParameter("ACTION"));

  // script variables for main page

  String requestURI = request.getRequestURI();
  String query = "VIEW=" + cartaProps.getViewPath() + 
    "&EXTENT=" + cartaProps.getExtentParam() +
    "&SIZE=" + cartaProps.getWidth() + "," + cartaProps.getHeight();
  String requestURL = requestURI + "?" + query;
  String mapURL = request.getContextPath() + "/MapImage" + "?" + query;
%>

<HTML>
<HEAD>
<TITLE>Map Viewer</TITLE>

<SCRIPT LANGUAGE="JavaScript">

<!-- 

if (window.opener != null) {
  window.opener.name = "ReportViewer"
}

current_picture = "";
last_picture = "";

function rollover_image (img_name, width, height) {

  if (navigator.appVersion.charAt(0) >=3) {

    img_prefix = "resources/" + img_name;

    this.rolloff_img = new Image (width, height);
    this.rolloff_img.src = img_prefix + "_u.gif";
    this.rollover_img = new Image (width, height);
    this.rollover_img.src = img_prefix +"_l.gif";
  }
}

function make_rollover_image (img_name, width, height) {
  rollover [img_name] = new rollover_image (img_name, width, height);
}

function rollover (img_name) {

  if (navigator.appVersion.charAt(0) >= 3) {

  current_picture = img_name;

    if (current_picture!=last_picture) {
 
      document [current_picture].src = 
        rollover [current_picture].rollover_img.src;
      if (last_picture != "") {
        document.images [last_picture].src = 
          rollover [last_picture].rolloff_img.src;
      }

      last_picture = current_picture;
    }
  }
}

function rolloff () {

  if (navigator.appVersion.charAt(0) >=3) {

    if (current_picture != "") {
      document.images [current_picture].src = 
        rollover [current_picture].rolloff_img.src;
    }

    current_picture = "";
    last_picture = "";
  }
}

make_rollover_image ("level1", 43, 15);
make_rollover_image ("level2", 43, 15);
make_rollover_image ("level3", 43, 15);
make_rollover_image ("level4", 43, 15);
make_rollover_image ("level5", 43, 15);
make_rollover_image ("level6", 43, 15);
make_rollover_image ("level7", 43, 15);
make_rollover_image ("level8", 43, 15);
make_rollover_image ("level9", 43, 15);
make_rollover_image ("level10", 43, 15);

// --> 

</SCRIPT>

</HEAD>
<BODY BGCOLOR="#EEEEEE">

<FORM METHOD=GET ACTION="<%=requestURI%>">

<CENTER>

<BR>

<TABLE WIDTH=582 BORDER=0>
<TR>
<TD ALIGN=RIGHT><font size=2 face="Helvetica, arial" color=000000>
<A HREF="http://www.scorecard.org/general/mapper/about.html" target=external>Help</A></TD>
</TR>
</TABLE>

<TABLE Z=1 bgcolor="#000000" border=0 cellpadding=0 cellspacing=0 width="582">
  <TR>
    <TD>
      <TABLE Z=2 width=100% border=0 cellpadding=2 cellspacing=1>

        <TR>
          <TD height=24 colspan=3 bgcolor=003366 align=center>
            <font size=2 face="Helvetica, arial" color=ffffff>
            <b><%= cartaProps.getTitle() %></b></TD>
        </TR>
        
        <TR>
          <TD valign=top bgcolor=ffffff width=200>
            <TABLE Z=3 width=100%>
              <TR>
                <TD align=center>
                <font size=2 face="verdana, Helvetica, arial" color=006666><BR>
                <b>Click on compass<BR>to move map</b></TD>
              </TR>
              <TR>
                <TD align=center>
                  <IMG SRC="resources/compass.gif" USEMAP="#compass" 
                   BORDER=0 vspace=3 WIDTH=73 HEIGHT=77>
<MAP NAME="compass">
<AREA SHAPE="POLY" COORDS="24,0,48,0,40,26,32,26" HREF=
  "<%=requestURL%>&ACTION=PAN,0,0.6">
<AREA SHAPE="POLY" COORDS="48,0,73,0,73,26,48,35,40,26" HREF=
  "<%=requestURL%>&ACTION=PAN,0.4,0.4">
<AREA SHAPE="POLY" COORDS="73,26,73,52,48,43,48,35" HREF=
  "<%=requestURL%>&ACTION=PAN,0.6,0">
<AREA SHAPE="POLY" COORDS="73,52,73,77,48,77,40,52,48,43" HREF=
  "<%=requestURL%>&ACTION=PAN,0.4,-0.4">
<AREA SHAPE="POLY" COORDS="48,77,24,77,32,52,40,52" HREF=
  "<%=requestURL%>&ACTION=PAN,0,-0.6">
<AREA SHAPE="POLY" COORDS="24,77,0,77,0,52,24,43,32,52" HREF=
  "<%=requestURL%>&ACTION=PAN,-0.4,-0.4">
<AREA SHAPE="POLY" COORDS="0,52,0,26,24,35,24,43" HREF=
  "<%=requestURL%>&ACTION=PAN,-0.6,0">
<AREA SHAPE="POLY" COORDS="0,26,0,0,24,0,32,26,24,35" HREF=
  "<%=requestURL%>&ACTION=PAN,-0.4,0.4">
<AREA SHAPE="DEFAULT" NOHREF>
</MAP>
                </TD>
              </TR>
            </TABLE>
                        
            <hr width=90%>
            
            <BR>

            <TABLE Z=3 width=100%>
              <TR>
                <TD colspan=2 align=center>
                <font size=2 face="verdana, Helvetica, arial" color=006666>
                <b>Click on map to:</b></TD>
              </TR>
              <TR>
                <TD align=right>
                <font size=2 face="verdana, Helvetica, arial" color=00000>
                Identify feature</TD>
                <TD><INPUT TYPE=RADIO NAME=ACTION VALUE="IDENTIFY"></TD>
              </TR>
              <TR>
                <TD align=right>
                <font size=2 face="verdana, Helvetica, arial" color=00000>
                Recenter map</TD>
                <TD><INPUT TYPE=RADIO CHECKED NAME=ACTION VALUE="RECENTER"></TD>
              </TR>
              <TR>
                <TD align=right>
                <font size=2 face="verdana, Helvetica, arial" color=00000>
                Recenter and zoom in</TD>
                <TD><INPUT TYPE=RADIO NAME=ACTION VALUE="LEVEL,<%=cartaProps.getZoomInScaleLevel()%>"></TD>
              </TR>
            </TABLE>
          </TD>
          
          <TD><INPUT TYPE=IMAGE NAME=MAP BORDER=0 WIDTH=300 HEIGHT=300
            SRC="<%=mapURL%>"></TD>
          
          <TD bgcolor=003366 width=75  valign=center>

            <TABLE Z=3 cellpadding=0 cellspacing=1 border=0 width=100% align=right>
              <TR>
                <TD colspan=2 align=center><A HREF=
  "<%=requestURL%>&ACTION=LEVEL,<%=cartaProps.getZoomOutScaleLevel()%>"><IMG 
            BORDER=0 SRC="resources/zoom_out.gif" WIDTH=47 HEIGHT=32></A></TD>
              </TR>
              
<% 
  int[] scaleLevels = cartaProps.getScaleLevels();
  int scaleLevel = cartaProps.getScaleLevel();
  for (int i = scaleLevels.length; i > 0; i--) {
%>

<TR>
  <TD><% if (i == scaleLevel) { %><IMG SRC="resources/arrow.gif"><% } %></TD>
  <TD><A HREF="<%=requestURL%>&ACTION=LEVEL,<%=i%>"
  onmouseover= "rollover ('level<%=i%>'); window.status = ' '; return true;" 
  onmouseout="rolloff (); window.status = '   '"><IMG 
  SRC="resources/level<%=i%>_u.gif" 
  name='level<%=i%>' width=43 height=15 vspace=2 border=0></A></TD>
</TR>

<% } %>

              <TR>
                <TD colspan=2 align=center><A HREF=
  "<%=requestURL%>&ACTION=LEVEL,<%=cartaProps.getZoomInScaleLevel()%>"><IMG 
            BORDER=0 SRC="resources/zoom_in.gif" WIDTH=47 HEIGHT=32></A></TD>
              </TR>
            </TABLE>
          </TD>
        </TR>

<TR>
<TD BGCOLOR=FFFFFF COLSPAN=3>
<TABLE Z=3 WIDTH=100%>
  <TR>
    <TD width=50% VALIGN=TOP BGCOLOR=FFFFFF>

    <TABLE BGCOLOR=#FFFFFF WIDTH=100% cellpadding=2 cellspacing=1 border=0>
    <TR><TD VALIGN=TOP BGCOLOR=#FFFFFF>
    <% if (cartaProps.getAction().equals("IDENTIFY")) { %>

    <font size=2 
      face="verdana, Helvetica, arial" color=000000><%
      Report[] reports = cartaProps.getReports();
      if (reports == null) { %>
        No feature found at the location you specified.
      <% } else if (reports.length == 0) { %>
        No reports available for the feature you selected.
      <% } else { %>

<font size=1 face="verdana, Helvetica, arial">
Reports available at the location you specified:
<BR>

<SCRIPT LANGUAGE="JavaScript">

<!-- Hide from older browsers

  function writeReportLink(url, label) {

    document.write(
      "<A HREF='javascript:reportIt(\"" +
        url + "\");'>" + label + "</A>"
    );

  };

  function reportIt(url) {
    
    reportWin = open(url, "ReportViewer");
    reportWin.focus()
  }

// Done hiding from older browsers -->

</SCRIPT>

<% for (int j=0; j < reports.length; j++) { %>

    <LI>
    
    <SCRIPT LANGUAGE=JavaScript>
    <!-- Hide from older browsers
      writeReportLink("<%=reports[j].url%>", "<%=reports[j].label%>");
    // Done hiding from older browsers -->
    </SCRIPT>
    
    <NOSCRIPT>
    <A HREF="<%=reports[j].url%>" 
       TARGET="ReportViewer"><%=reports[j].label%></A>
    </NOSCRIPT>
    
    </LI>

<% } %>

    <% } %></FONT><% } %></TD></TR>
    </TABLE>

    </TD>

    <TD>|</TD>

    <TD valign=top align=left BGCOLOR=#FFFFFF><font size=2 
      face="verdana, Helvetica, arial" color=000000>Key to Map Symbols

      <TABLE WIDTH=100% cellpadding=2 cellspacing=1 border=0>

<% 
  Legend[] legends = cartaProps.getLegends();
  int scale = cartaProps.getScale();
  for (int k = 0; k < legends.length; k++) { 

    Legend legend = legends[k];
    if (legend == null) { continue; }
    if (! legend.layerProps.getVisibility(scale)) { continue; }

    String[] labels = legend.labels;
    String layerPath = StringTools.getRelativePath(
      cartaProps.getPath(), legend.layerProps.getPath());
%>

<TR><TD COLSPAN=2 BGCOLOR=#FFFFFF><font size=1 face="verdana,Helvetica,arial" color="#000000"><B><%=legend.layerProps.getTitle()%></B></TD></TR>

<%   for (int m = 0; m < labels.length; m++) { %>

<TR><TD ALIGN=CENTER BGCOLOR=#FFFFFF><IMG SRC="<%=request.getContextPath()%>/Symbol?LAYER=<%=layerPath%>&INDEX=<%=m%>"></TD><TD BGCOLOR=#FFFFFF><font size=1 face="verdana,Helvetica,arial" color="#000000"><%=labels[m]%></TD></TR>

<%   } %>

<% } %>
      </TABLE>


    </TD>
  <TR>
</TABLE>
</TD>
</TR>

      </TABLE>
    </TD>
  </TR>
</TABLE>

  <INPUT TYPE=HIDDEN NAME=VIEW VALUE="<%=cartaProps.getViewPath()%>">
  <INPUT TYPE=HIDDEN NAME=EXTENT VALUE="<%=cartaProps.getExtentParam()%>">
  <INPUT TYPE=HIDDEN NAME=SIZE VALUE="<%=cartaProps.getSizeParam()%>">

</CENTER>
</FORM>

</BODY>
</HTML>
