/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.tools;

import pms.FormatException;

public class UnitConverter {

  public static double measure(double value, String fromUnits, String toUnits) 
    throws FormatException {

    try {
      Class thisClass = Class.forName("pms.tools.UnitConverter");

      double fromFactor = ((Double) StringTools.toEnumeration(thisClass, 
        "METERS_TO_" + fromUnits.toUpperCase())).doubleValue();
      value /= fromFactor;
      double toFactor = ((Double) StringTools.toEnumeration(thisClass, 
        "METERS_TO_" + toUnits.toUpperCase())).doubleValue();
      value *= toFactor;

    } catch (Exception e) {
      throw new FormatException("Could not convert measure from " + 
        fromUnits + " to " + toUnits + " (" + e.getMessage() + ")");
    }

    return value;
  } 

  public static double METERS_TO_INCHES = 39.37;
  public static double METERS_TO_METERS = 1;
}
