/**

Copyright (C) 1999-2001 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.tools;

import java.io.File;
import java.lang.reflect.*;
import java.net.*;
import java.util.*;

import pms.FormatException;

public class StringTools {
  
  public static Object toEnumeration(Object o, String field) 
    throws FormatException {

    return toEnumeration(o.getClass(), field);
  }

  public static Object toEnumeration(Class thisClass, String field) 
    throws FormatException {

    Object enum;

    try {
      enum =  thisClass.getField(field).get(null);
    } catch (Exception e) {
      System.err.println(e);
      throw new FormatException("Unknown enumeration option " + field);
    }
    return enum;
  }

  public static int toInt(String s) throws FormatException {

    StringBuffer sb = new StringBuffer(s.length());
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c != ',') sb.append(c);
    }
    
    int i = 0;
    try {
      i = Integer.parseInt(sb.toString());
    } catch (NumberFormatException e) {
      throw new FormatException(e.getMessage());
    }

    return i;
  }

  public static String intToString(int i) {

    String s = Integer.toString(i);
    if (s.length() < 4) return s;

    int commaCount = s.length() / 3;
    StringBuffer sb = new StringBuffer();

    int index = s.length() % 3;
    if (index == 0) {
      commaCount--;
      index = 3;
    }

    sb.append(s.substring(0, index));
    for (int j = 0; j < commaCount; j++) {
      sb.append(',');
      sb.append(s.substring(index, index + 3));
      index += 3;
    }

    return sb.toString();
  }

  public static double toDouble(String s) throws FormatException {

    double d = 0;
    try {
      d = Double.parseDouble(s);
    } catch (NumberFormatException e) {
      throw new FormatException(e.getMessage());
    }

    return d;
  }

  public static String toTitleCase(String s) {

    StringBuffer b = new StringBuffer(s.toLowerCase());
    b.setCharAt(0, Character.toUpperCase(b.charAt(0)));
    
    return b.toString();
  }

  public static String trim(String s, char fore, char aft) {

    s = s.trim();
    if (s.charAt(0) == fore)
      s = (s.length() > 1) ? s.substring(1) : "";
    if (s.length() == 0) return s;

    if (s.charAt(s.length() - 1) == aft)
      s = s.substring(0, s.length() - 1);

    return s;
  }

  public static String resolvePath(String parent, String child) {

    Debug.assertNotNull("StringTools.resolvePath", "child", child);

    if ((new File(child)).isAbsolute())
      return child;

    if (parent == null)
      return (new File(child)).getAbsolutePath();

    File parentFile = new File(parent);
    if (parentFile.isFile())
      parent = parentFile.getParent();

    return (new File(parent, child)).getAbsolutePath();
  }

  public static String getRelativePath(String parent, String child) {

    if (child.indexOf(parent) != 0) return child;

    int length = parent.length();

    // adjust length for trailing slash
    if (parent.charAt(length - 1) != '/') length++;

    return child.substring(length);
  }

  public static String getExtension(String path) {

    String baseName = (new File(path)).getName();

    int dotIndex = baseName.lastIndexOf('.');
    if ((dotIndex == -1) || (dotIndex == baseName.length() - 1)) 
      return "";
   
    return baseName.substring(dotIndex + 1);
  }

  public static String setExtension(String path, String extension) {
    
    String ext = getExtension(path);
    if (ext.equals(extension)) return path;
    if (ext.equals("")) return path + "." + extension;

    int dotIndex = path.lastIndexOf('.');
    return path.substring(0, dotIndex + 1) + extension;
  }
}
