/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.tools;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;

import pms.*;
import pms.shape.*;
import pms.table.*;

public class ShapeSelector extends ShapeCompactor {

  public static void main(String[] args) {
    
    if (args.length <= 4) {
      System.err.println(
        "Usage: [in file] [out file] [selection field] [selection values...]"); 
      System.exit(0);
    }

    try {

      HashMap values = new HashMap();
      for (int i = 3; i < args.length; i++) {
        values.put(args[i], "");
      }
      ShapeSelector selector = new ShapeSelector(args[1], args[0]);
      selector.select(args[0], args[2], values);
      selector.close();

    } catch (Exception e) {
      e.printStackTrace();
    }
    System.exit(0);
  }

  public ShapeSelector(String outName, String templateName) 
    throws IOException {

    create(outName, templateName);
  }

  public void select(String inName, String selectField, HashMap values) 
    throws IOException {

    initAppend(inName);
    System.err.println("Adding " + inShape.getRecordCount() +
      " records from " + inName);

    DBaseFile dbFile = inShape.getTable();
    int column = dbFile.getColumn(selectField);
    Attribute selectAttribute = new Attribute(dbFile, column);
 
    for (int r = 1; r <= inShape.getRecordCount(); r++) {

      String selectValue = selectAttribute.getValue(r);
      if (values.get(selectValue) != null)
        writeRecord(r);
    }
  }
}
