/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.tools;

public class LittleEndian {

  public static short toShort(short i) { 

    int t;
    short r = 0;

    t = (i >> 8) & 0xFF;
    r |= t;
    t = (short) (i << 8);
    r |= t;

    return r;
  }

  public static int toInt(int i) {

    int t, r = 0;
    
    t = i >>> 24;
    r |= t;

    t = i >>> 8;
    r |= (t & 0x0000FF00);
  
    t = i << 8;
    r |= (t & 0x00FF0000);

    t = i << 24;
    r |= t;

    return r;
  }

  public static double toDouble(long i) {
    
    return Double.longBitsToDouble(toLong(i));
  } 

  public static long toLong(long l) {

    long t, r = 0;

    t = l >>> 56;
    r |= t;

    t = l >>> 40;
    r |= (t & 0x000000000000FF00L);

    t = l >>> 24;
    r |= (t & 0x0000000000FF0000L);

    t = l >>> 8;
    r |= (t & 0x00000000FF000000L);

    t = l << 8;
    r |= (t & 0x000000FF00000000L);

    t = l << 24;
    r |= (t & 0x0000FF0000000000L);

    t = l << 40;
    r |= (t & 0x00FF000000000000L);

    t = l << 56;
    r |= t;

    return r;
  }
}
