package pms.tools;

import java.io.*;
import java.util.*;

public class DirCrawler {

    public static ArrayList getFiles(String path, String ext) 
        throws Exception {

	ArrayList list = new ArrayList();
	getFiles(new File(path), ext, list);
	return list;
    }

    public static void getFiles(File dir, String ext, ArrayList list) 
        throws Exception {

	if (! dir.isDirectory()) return;
	String[] files = dir.list();
        for (int i = 0; i < files.length; i++) {

	    File file = new File(dir, files[i]);
	    if (file.isDirectory()) getFiles(file, ext, list);

	    if ((ext == null) || (getExtension(file).equals(ext))) 
                list.add(file);
	}
    }

    public static String getExtension(File file) {

        String baseName = file.getName();

        int dotIndex = baseName.lastIndexOf('.');
        if ((dotIndex == -1) || (dotIndex == baseName.length() - 1))
            return "";

        return baseName.substring(dotIndex + 1);
    }

    public static void main(String[] args) {

	try {
            ArrayList list = DirCrawler.getFiles(args[0], args[1]);
	    for (Iterator i = list.iterator(); i.hasNext();) {
		System.out.println(i.next());
	    }
	} catch (Exception e) {

	    e.printStackTrace();
	}
    }
}
