/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.tools;

import org.apache.log4j.Category;

public class Debug {

  private static Category log = 
    Category.getInstance(Debug.class.getName());

  public static void checkVersion(String needVersion) {

    String version = System.getProperty("java.version");
    if (version.compareTo(needVersion) < 0) {
      System.err.println("Java version " + needVersion + 
        " or greater required. Exiting...");
      System.exit(0);
    }
  }

  public static void printMemory() {

    Runtime runtime = Runtime.getRuntime();
    long free = runtime.freeMemory();
    long total = runtime.totalMemory();
    long pcnt = free * 100 / total;
    System.err.println("Memory: " + free + " of " + total + 
      " (" + pcnt + "%)");
  }

  // not thread aware!
  public static void initTimeElapsed() {

    time = System.currentTimeMillis();
  }

  public static void printTimeElapsed(String msg) {

    long elapsed = System.currentTimeMillis() - time;
    log.info(msg + ": " + elapsed + " ms");
    initTimeElapsed();
  }

  public static void printTimeElapsed() {

    printTimeElapsed("Time elapsed");
  }

  public static void assertNotNull(String method, String param, Object value) {

    if (value == null) 
      throw new NullPointerException("Unexpected null value for parameter " + 
				     param + " in method " + method);
  }

  private static long time = System.currentTimeMillis();

  public static boolean verbose = true;
}




