/** 

Copyright (C) 1999-2001 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.template;

import java.io.*;
import java.net.*;
import java.util.*;

import pms.tools.*;

public class TemplatePublisher {

  public TemplatePublisher(Object obj) {

    refClass = (obj == null) ? this.getClass() : obj.getClass();
  }

  public HashMap scan(String template) throws IOException {

    HashMap params = new HashMap();
    StreamTokenizer st =
      new StreamTokenizer(retrieve(refClass, template));

    initTokenizer(st);
    int last_ttype = 0;

    while (st.nextToken() != StreamTokenizer.TT_EOF) {
      if (st.ttype == '$') {
        if ((last_ttype != '\\') &&
            (st.nextToken() == StreamTokenizer.TT_WORD)) {
          params.put(st.sval, "");
        }
      }
      last_ttype = st.ttype;
    }
    return params;
  }

  public void write(String template, HashMap params,
    PrintStream printStream) throws IOException {

    StreamTokenizer st = new StreamTokenizer(
      retrieve(refClass, template));

    initTokenizer(st);
    int last_ttype = 0;

    while (st.nextToken() != StreamTokenizer.TT_EOF) {
      switch (st.ttype) {
        case StreamTokenizer.TT_WORD:
          printStream.print(st.sval);
          break;
        case '$':
          if ((last_ttype != '\\') &&
              (st.nextToken() == StreamTokenizer.TT_WORD)) {
            String var = (String) params.get(st.sval);
            if (var != null)
              printStream.print(var);
          }
          break;
        default:
          printStream.print((char) st.ttype);
      }
      last_ttype = st.ttype;
    }
  }

  private void initTokenizer(StreamTokenizer st) {

    st.resetSyntax();
    st.wordChars(48,57);
    st.wordChars(65,90);
    st.wordChars(95,95);
    st.wordChars(97,122);
  }

  private static StringReader retrieve(Class refClass, String path) 
    throws IOException {

    path = StringTools.setExtension(path, "template");
    URL url = refClass.getResource(path);
    if (url == null) {
      throw new IOException("Template file " + path + " not found.");
    }
    path = url.getFile();

    StringReader sr = (StringReader) cache.get(path);
    if (sr == null) {

      File file = new File(path);
      char[] buffer = new char[(int) file.length()];
      FileReader fr = new FileReader(file);
      fr.read(buffer);
      sr = new StringReader(new String(buffer)); 
      cache.put(path, sr);
    }
    sr.reset();

    return sr;
  }

  public static void flushCache() {
    cache.clear();
  }

  private Class refClass;

  private static Hashtable cache = new Hashtable();
}
