/** 

Copyright (C) 1999-2001 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.template;

import java.io.*;

public class ContentBuffer extends ByteArrayOutputStream {

  public ContentBuffer() { 
    super(); 
  }

  public ContentBuffer(int size) {
    super(size);
  }

  public void writeTo(OutputStream out) throws IOException {
    
    int offset = 0;
    while (offset < count) {
      int remaining = count - offset;
      int len = (remaining > 4096) ? 4096 : remaining;
      out.write(buf, offset, len);
      offset += len;
    }
  }

  protected void readFromFile(File file) throws IOException {

    FileInputStream in = new FileInputStream(file);
    int length = (int) file.length();
    int pos = 0;

    while (pos < length) {

      int remaining = length - pos;
      int len = (remaining > 4096) ? 4096 : remaining;
      pos += len;

      in.read(buf, count, len);
      count += len;
    }
    close();
  }

  public static ContentBuffer readFromFile(String path) throws IOException {

    File file = new File(path);
    int length = (int) file.length();
    ContentBuffer out = new ContentBuffer(length);
    out.readFromFile(file);
  
    return out;
  }
}

