/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.table;

import java.io.*;
import java.sql.*;
import java.util.*;

import org.apache.log4j.Category;

public class QueryFactory {

  private static Category log = 
    Category.getInstance(QueryFactory.class.getName());

  public QueryFactory() throws IOException {

    try {
      connection = ConnectionManager.getConnection();
    } catch (Exception e) {
      log.info(e);
      throw new IOException("Unable to borrow database connection (" +
        e.getMessage() + ")");
    }

    try {
      statement = connection.createStatement();
    } catch (Exception e) {
      log.info(e);
      throw new IOException("Unable to create connection statement (" +
        e.getMessage() + ")");
    }
  }

  public void execute(ArrayList resultFields, String table, 
    String keyField, ArrayList keyValues) throws IOException {

    String sql;
    if (resultFields != null) {
      Iterator e = resultFields.iterator();
      sql = "SELECT " + e.next();
      while (e.hasNext())
        sql += "," + e.next();
    } else {
      sql = "SELECT *";
    }
    sql += " FROM " + table;

    if (keyField != null) {
      sql += " WHERE " + keyField + " IN (";

      Iterator e = keyValues.iterator();
      sql += "'" + (String) e.next() + "'";
      while (e.hasNext())
        sql += ",'" + (String) e.next() + "'";

      sql += ")";
    }

    log.info("Executing query: " + sql);
    try {
      resultSet = statement.executeQuery(sql);
    } catch (Exception exception) {
      throw new IOException("Error executing database query (" +
        exception.getMessage() + ")");
    }
  }

  public HashMap store(HashMap records, String keyField) 
    throws IOException {

    HashMap fields = new HashMap();

    try {

      ResultSetMetaData metaData = resultSet.getMetaData();
      int columnCount = metaData.getColumnCount();

      for (int i = 1; i <= columnCount; i++) {
        fields.put(metaData.getColumnName(i).toUpperCase(), new Integer(i));
      }

      if (keyField == null) return fields;
      records.clear();

      while (resultSet.next()) {

        String keyValue = resultSet.getString(keyField);
        String[] record = new String[columnCount];

        for (int i = 1; i <= columnCount; i++) {
          record[i - 1] = resultSet.getString(i);
        }
        records.put(keyValue, record);
      }

      resultSet.close();

    } catch (Exception e) {
      throw new IOException("Error parsing query result (" +
        e.getMessage() + ")");
    }

    return fields;
  }

  public void close() throws IOException {

    try {
      statement.close();
      connection.close();
    } catch (SQLException e) {
      throw new IOException("Error closing database statement (" +
        e.getMessage() + ")");
    }
  }

  private Connection connection;
  private Statement statement;
  private ResultSet resultSet;
}
