package pms.table;

import java.io.*;
import java.sql.*;
import java.util.*;

import org.apache.log4j.Category;

public class Query implements AttributeSource {

  private static Category log = 
    Category.getInstance(Query.class.getName());

  public Query(DBaseFile keyFile, int keyColumn)
    throws IOException {
    
    this.keyFile = keyFile;
    this.keyColumn = keyColumn;
    this.queryFactory = new QueryFactory();
  }

  public Query(
    DBaseFile keyFile, int keyColumn, QueryFactory queryFactory) {

    this.keyFile = keyFile;
    this.keyColumn = keyColumn;
    this.queryFactory = queryFactory;
  }

  public void setStatement(
    ArrayList requestFields, String table, String keyField) {

    this.table = table;
    this.keyField = keyField;
    this.requestFields = requestFields;
  }

  public void setRecords(ArrayList selection) throws IOException {

    ArrayList keyValues = new ArrayList();

    for (Iterator i = selection.iterator(); i.hasNext();) {
      Integer record = (Integer) i.next();
      int r = record.intValue();

      String keyValue = keyFile.getValue(r, keyColumn);
      if (keyValue.equals("")) continue;
      keyValues.add(keyValue);
      lookup.put(record, keyValue);
    }

    queryFactory.execute(requestFields, table, keyField, keyValues);
    fields = queryFactory.store(records, keyField);
  }

  public void setColumns(ArrayList selection) throws IOException {

    selectedColumns = new int[selection.size()];
    for (int i = 0; i < selectedColumns.length; i++) {

      selectedColumns[i] = getColumn((String) selection.get(i));
    }
  }

  public int getColumn(String fieldName) throws IOException {

    Integer column = (Integer) fields.get(fieldName.toUpperCase());
    if (column == null)
      throw new IOException(
        "Could not find field in database table: " + fieldName);
    return column.intValue();
  }

  public String getValue(int row, int col) 
    throws IOException, ArrayIndexOutOfBoundsException {

    String value = null;

    String[] record = getFullRecord(row);
    if (record != null)
      value = record[col - 1];

    if (value != null) value = value.trim();

    return value;
  }

  public String[] getFullRecord(int row) throws IOException {

    if (row < 0)
      throw new IOException("Invalid row number " + row);

    String[] record = null;

    String key = (String) lookup.get(new Integer(row));
    if (key != null)
      record = (String[]) records.get(key);
     
    if (record == null)
      log.info("No value for key " + key + " in database table " + table);

    return record;
  }

  public String[] getRecord(int row) throws IOException {

    String[] fullRec = getFullRecord(row);
    if (fullRec == null) return null;

    String[] rec = new String[selectedColumns.length];

    for (int i = 0; i < rec.length; i++) {
      rec[i] = fullRec[selectedColumns[i] - 1];
    }

    return rec;
  }

  public Attribute getAttribute(String field) throws IOException {

    int column = getColumn(field);   
    return new Attribute(this, column);
  }

  public void close() throws IOException {
    
    queryFactory.close();
  }

  DBaseFile keyFile;
  int keyColumn;
  QueryFactory queryFactory;

  ArrayList requestFields;
  String table;
  String keyField;

  int[] selectedColumns;

  HashMap records = new HashMap();
  HashMap fields = new HashMap();
  HashMap lookup = new HashMap();
}
