package pms.table;

import java.io.*;
import java.sql.*;
import java.util.*;

import oracle.jdbc.pool.*;
import oracle.sql.*;

/**
 * A class for obtaining database connections from a pool.
 *
 * @author Karl Goldstein (karlg@arsdigita.com)
 *
 * @version $Id: ConnectionManager.java,v 1.1 2001/07/15 16:41:57 karl Exp $
*/

public class ConnectionManager {

  private static OracleConnectionCacheImpl connectionCache = null;
  private static Properties properties = null;

  static {
  
    try {

      initializeConnectionCache();

    } catch (Exception e) {

      System.out.println(e);
      System.exit(1);
    }
  }

  private static void initializeConnectionCache() throws SQLException {

    OracleConnectionPoolDataSource dataSource = null;
    dataSource = new OracleConnectionPoolDataSource();

    dataSource.setURL(System.getProperty("database.url"));
    dataSource.setUser(System.getProperty("database.user"));
    dataSource.setPassword(System.getProperty("database.password"));
    dataSource.setNetworkProtocol("ipc");

    connectionCache = new OracleConnectionCacheImpl(dataSource);
    connectionCache.setMaxLimit(8);
    connectionCache.setCacheScheme(connectionCache.FIXED_RETURN_NULL_SCHEME);
  }

  /**
   * Retrieve a reference to the cached database connection. Open a
   * new connection if neccesary.
   *
   * @return A database connection 
   **/
  public static Connection getConnection() throws SQLException {

    int counter = 50;
    Connection conn = null;

    do {

      conn = connectionCache.getConnection();
	  
      if (conn == null) {

	if (counter-- == 0) {
	  throw new SQLException(
            "Could not obtain database handle after 50 tries, giving up.");
	}

	try { Thread.sleep(100); } catch (InterruptedException e) {} 
      }

    } while (conn == null);

    conn.setAutoCommit(false);

    return conn;
  }

  public static void main(String[] args) throws SQLException {

    Connection conn = ConnectionManager.getConnection();

    Statement stmt = conn.createStatement();
    ResultSet rs = stmt.executeQuery("select sysdate from dual");

    rs.next();

    java.sql.Date sysdate = rs.getDate(1);

    System.out.println("Query successful.  Sysdate is " + sysdate);

    rs.close();
    stmt.close();
    conn.close();
  }
}

