/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.shape;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;

import pms.tools.Debug;

public abstract class Tesselation {

  public Enumeration iterate(Rectangle2D.Double box) 
    throws IOException {
    
    Vector list = new Vector();

    Point min = pointToTesselation(box.x, box.y - box.height);
    if (min.x < 0) min.x = 0; 
    if (min.y < 0) min.y = 0;

    Point max = pointToTesselation(box.x + box.width, box.y);
    if (max.x >= cols) max.x = cols - 1; 
    if (max.y >= rows) max.y = rows - 1; 

    for (int i = min.x; i <= max.x; i++) {
      for (int j = min.y; j <= max.y; j++) {
        int[] cell = getCell(i ,j);
        if (cell.length > 0)
          list.addElement(cell);
      }
    }

    return list.elements();
  }

  public int[] getCellAt(double x, double y) throws IOException {

    Point p = pointToTesselation(x, y);
    return getCell(p.x, p.y);
  }

  public static boolean intersects(Rectangle2D.Double a, 
    Rectangle2D.Double b) {

    if (a.x + a.width < b.x) return false;
    if (b.x + b.width < a.x) return false;
    if (a.y - a.height > b.y) return false;
    if (b.y - b.height > a.y) return false;

    return true;
  }

  public Point pointToTesselation(double x, double y) {

    int col = (int) Math.floor((x - extent.x) / cellSize);
    int row = (int) Math.floor((y - (extent.y - extent.height)) / cellSize);

    // if (Debug.verbose)
    // System.err.println("Pt->Ts:" + x + "," + y + " -> " + col + "," + row);
        
    return new Point(col, row);
  }

  public int getColumns() {

    return cols;
  }

  public int getRows() {

    return rows;
  }

  public double getCellSize() {

    return cellSize;
  }

  public String toString() {

    return "Left: " + extent.x + " Top:" + extent.y + "\n" +
      "Width: " + extent.width + " Height:" + extent.height + "\n" +
      "Cell size: " + cellSize + "\n" +
      "Rows: " + rows + " Cols: " + cols;
  }

  public abstract int[] getCell(int col, int row) throws IOException;
  protected abstract void close() throws IOException;

  protected double cellSize;
  protected Rectangle2D.Double extent;
  protected int rows;
  protected int cols;
}
