package pms.shape;

import java.awt.geom.*;
import java.sql.*;

import pms.table.*;

public class SQLExtentTable {

  public SQLExtentTable(ShapeFile shapeFile, String name, String[] fields) {

    try {
      Connection conn = ConnectionManager.getConnection();
      Statement statement = conn.createStatement();

      String ddl = "create table " + name + " ( " +
	"xmin number, ymin number, xmax number, ymax number";

      DBaseFile dBaseFile = shapeFile.getTable();
      Attribute[] attributes = new Attribute[fields.length];
      for (int i = 0; i < fields.length; i++) {
	attributes[i] = dBaseFile.getAttribute(fields[i]);
	int len = dBaseFile.getColumnLength(attributes[i].getColumn());
        ddl += ", " + fields[i] + " varchar(" + len + ")";
      }
        
      ddl += " )";

      System.err.println(ddl);
      statement.executeUpdate(ddl);
      conn.commit();
      statement.close();
      statement = conn.createStatement();
 
      for (int i = 1; i <= shapeFile.getRecordCount(); i++) {
        Rectangle2D.Double bounds = shapeFile.getBounds(i);
   
        if (bounds != null) {
	  
          String dml = "insert into " + name + " values ( " +
	    bounds.x + "," + bounds.y + "," + 
	    (bounds.x + bounds.width) + "," + (bounds.y + bounds.height);

	  for (int j = 0; j < attributes.length; j++) {
	    dml += ",'" + attributes[j].getValue(i) + "'";
	  }
	  dml += ")";
          System.err.println(dml);
	  statement.executeUpdate(dml);

        }
      }
     
      statement.close();
      conn.close();

    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  public static void main(String[] args) {

    if (args.length < 3) {

      System.err.println(
        "Usage: java SQLExtentTable [shape file] [table name] [field names...]");
      System.exit(0);
    }

    String path = args[0];
    String tableName = args[1];
    String[] fieldNames = new String[args.length - 2];
    
    for (int i = 0; i < fieldNames.length; i++) {
      fieldNames[i] = args[i + 2];
    }

    try {

      ShapeFile shapeFile = ShapeFile.create(path);
      new SQLExtentTable(shapeFile, tableName, fieldNames);

      System.err.println("Extent table created successfully.");

    } catch (Exception e) {

      e.printStackTrace();
    }
  }
}
