package pms.shape;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.net.*;
import java.util.*;

import pms.tools.*;

public class PolygonFile extends LineFile {

  public Object getShape(int r) throws IOException {

    DataInput recordStream = readShapeRecord(r, 36);
    int numParts = LittleEndian.toInt(recordStream.readInt());
    int numPoints = LittleEndian.toInt(recordStream.readInt());
      
    int[] partOffsets = new int[numParts + 1];
    for (int i = 0; i < numParts; i++)
      partOffsets[i] = LittleEndian.toInt(recordStream.readInt());
    partOffsets[numParts] = numPoints - 1;

    path.reset();

    int currentPart = 0;
    for (int i = 0; i < numPoints; i++) {

      float x = (float) LittleEndian.toDouble(recordStream.readLong());
      float y = (float) LittleEndian.toDouble(recordStream.readLong());

      if (i == partOffsets[currentPart]) {
        if (currentPart > 0) path.closePath();
        path.moveTo(x, y);
        currentPart++;
      } else {
        path.lineTo(x, y);
      }
    }

    return path;
  }

  public Integer identify(double x, double y, double tolerance)
    throws IOException {

    Rectangle2D.Double extent = new Rectangle2D.Double(
      x - tolerance, y + tolerance, tolerance * 2, tolerance * 2);

    ArrayList selection = selectByRect(extent);

    Integer result = null;

    for (Iterator i = selection.iterator(); i.hasNext();) {

      Integer record = (Integer) i.next();
      int r = record.intValue();

      getShape(r);
      if (path.contains(x, y)) {
        return record;
      }
    }

    return null;
  }

  public Object getCoords(Area viewPort) {

    Area pathArea = new Area(path);
    pathArea.intersect(viewPort);
    path = new GeneralPath(pathArea);

    ArrayList ringList = new ArrayList();
    PathIterator iterator = path.getPathIterator(null);
    float[] segment = new float[6];
    int lastX = Integer.MAX_VALUE;
    int lastY = Integer.MAX_VALUE;
    ArrayList vertexList = new ArrayList();

    while (! iterator.isDone()) {
 
      int segmentType = iterator.currentSegment(segment);

      if (segmentType == PathIterator.SEG_MOVETO) {
        vertexList = new ArrayList(); 
        ringList.add(vertexList);
      }
     
      int x = Math.round(segment[0]);
      int y = Math.round(segment[1]);
      int xdiff = Math.abs(x - lastX);
      int ydiff = Math.abs(y - lastY);
      if ((xdiff > 3) || (ydiff > 3)) {
        lastX = x;
        lastY = y;
        vertexList.add(new Point(x, y));
      }
      iterator.next();
    }

    return ringList;
  }
}
