package pms.shape;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.net.*;
import java.util.*;

import pms.tools.*;

public class PointFile extends ShapeFile {

  public Rectangle2D.Double getBounds(int r) throws IOException {

    getShape(r);

    return new Rectangle2D.Double(point.x, point.y, 0, 0);
  }

  public Object getShape(int r) throws IOException {

    int recPos = FILE_HEADER_LENGTH + (28 * (r - 1)) + 
                 RECORD_HEADER_LENGTH + 4;
    shapeFile.seek(recPos);

    float x = (float) LittleEndian.toDouble(shapeFile.readLong());
    float y = (float) LittleEndian.toDouble(shapeFile.readLong());

    point.setLocation(x, y);

    return point;
  }

  public Object getShape(int r, AffineTransform transform) 
    throws IOException {

    getShape(r);
    transform.transform(point, point);

    return point;
  }

  public Integer identify(double x, double y, double tolerance) 
    throws IOException {

    Rectangle2D.Double extent = new Rectangle2D.Double(
      x - tolerance, y + tolerance, tolerance * 2, tolerance * 2);
    System.err.println(extent);

    ArrayList selection = selectByRect(extent);
    double minDistance = Double.MAX_VALUE;
    Integer result = null;

    for (Iterator i = selection.iterator(); i.hasNext();) {

      Integer record = (Integer) i.next();
      int r = record.intValue();

      getShape(r);
      double distance = point.distance(x, y);
      System.err.println(distance);
      if (distance < minDistance) {
        minDistance = distance;
        result = record;
      }
    }

    return result;
  }

  public Object getCoords(Area viewPort) {

    point = (Point2D.Float) point;

    return new Point((int) point.x, (int) point.y);
  }

  protected Point2D.Float point = new Point2D.Float();
}
