/**

Copyright (C) 1999 Karl Goldstein

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**/

package pms.shape;

import java.awt.geom.*;
import java.io.*;
import java.net.*;

public class LineFloatFile extends LineFile {

  public LineFloatFile() {
    RECORD_HEADER_LENGTH = 0;
  }

  public Rectangle2D.Double getBounds(int r) throws IOException {

    getShape(r);

    Rectangle2D.Float pathBounds = (Rectangle2D.Float) path.getBounds2D();

    return new Rectangle2D.Double(pathBounds.x, 
      pathBounds.y + pathBounds.height, pathBounds.width, pathBounds.height);
  }

  protected Rectangle2D.Double readBounds(DataInput in) throws IOException {

    float Xmin = in.readFloat();
    float Ymin = in.readFloat();
    float Xmax = in.readFloat();
    float Ymax = in.readFloat();
    double width = Xmax - Xmin;
    double height = Ymax - Ymin;

    return new Rectangle2D.Double((double) Xmin, (double) Ymax, width, height);
  }

  public Object getShape(int r) throws IOException {

    DataInput recordStream = readShapeRecord(r, 0);
    int numParts = recordStream.readInt();
    int numPoints = recordStream.readInt();
      
    int[] partOffsets = new int[numParts + 1];
    for (int i = 0; i < numParts; i++)
    partOffsets[i] = recordStream.readInt();
    partOffsets[numParts] = numPoints;

    path.reset();

    int currentPart = 0;
    for (int i = 0; i < numPoints; i++) {

      float x = recordStream.readFloat();
      float y = recordStream.readFloat();

      if (i == partOffsets[currentPart]) {
        path.moveTo(x, y);
        currentPart++;
      } else {
        path.lineTo(x, y);
      }
    }

    return path;
  }

  public Integer identify(double x, double y, double tolerance)
    throws IOException {

    Integer result = null;

    return result;
  }
}
